//
// IO-Warrior kit library V1.2 include file
//

#ifdef IOWKIT_EXPORTS
/*
#define IOWKIT_API __declspec(dllexport)
#else
#define IOWKIT_API __declspec(dllimport)
*/
#define IOWKIT_API __stdcall
#define	IOWKIT_APIX	__declspec(dllexport)
#else
#define IOWKIT_API __stdcall
#define	IOWKIT_APIX	__declspec(dllimport)
#endif

// IOW Library definitions
#ifndef	_IOW_KIT_H_
#define	_IOW_KIT_H_

// IoWarrior vendor & product IDs
#define	IOWKIT_VENDOR_ID		0x07c0
// IOW40 product ID
#define	IOWKIT_PRODUCT_ID_IOW40		0x1500
// IOW24 product ID (IOW with SPI)
#define	IOWKIT_PRODUCT_ID_IOW24		0x1501

// Max number of pipes per IOW device
#define	IOWKIT_MAX_PIPES	2
// Max number of IOW devices in system
#define	IOWKIT_MAX_DEVICES	16
// IOW Legacy devices open modes
// Open simple endpoints
#define	IOW_OPEN_SIMPLE		1
// Open complex endpoints
#define	IOW_OPEN_COMPLEX	2

// Debugging stuff
#define	DBG_ALL		~0x0L

#define	IOW_DBG
#ifdef	IOW_DBG

#ifdef	__cplusplus
extern "C" {
#endif
extern IOWKIT_APIX ULONG IowKitDebugLevel;
#ifdef	__cplusplus
}
#endif

#define	DbgOut(_level_, _msg_)	\
	if (IowKitDebugLevel & (_level_)) { \
		printf _msg_; \
	}

#else
#define	DbgOut(dummy,dummy1)
#endif

// Don't forget to pack it!
#pragma	pack(1)

typedef struct _IOWKIT_REPORT {
	UCHAR ReportID;
	DWORD Value;
} IOWKIT_REPORT, *PIOWKIT_REPORT;

#define	IOWKIT_REPORT_SIZE	sizeof(IOWKIT_REPORT)

// Opaque IO-Warrior handle
typedef	PVOID IOWKIT_HANDLE;

#ifdef	__cplusplus
extern "C" {
#endif
// Function prototypes
// Find and open IoWarrior device
IOWKIT_HANDLE IOWKIT_API
IowKitOpenDevice(VOID);

// Close device
VOID IOWKIT_API 
IowKitCloseDevice(IOWKIT_HANDLE devHandle);

// Write to interface
ULONG IOWKIT_API 
IowKitWrite(IOWKIT_HANDLE devHandle, ULONG numPipe,
	PCHAR buffer, ULONG length);

// Read from interface
ULONG IOWKIT_API 
IowKitRead(IOWKIT_HANDLE devHandle, ULONG numPipe,
	PCHAR buffer, ULONG length);

// Get last read value
BOOLEAN IOWKIT_API
IowKitReadImmediate(IOWKIT_HANDLE devHandle, PDWORD value);

// Async events handling
BOOLEAN IOWKIT_API
IowKitRegisterMsgCallback(IOWKIT_HANDLE iowHandle, HWND hWnd, UINT Msg);

BOOLEAN IOWKIT_API
IowKitRegisterMsgCallback(IOWKIT_HANDLE iowHandle, HWND hWnd, UINT Msg);

// Multiple devices support
ULONG IOWKIT_API
IowKitGetNumDevs(VOID);

IOWKIT_HANDLE IOWKIT_API
IowKitGetDeviceHandle(ULONG numDevice);

// Legacy open mode
BOOLEAN IOWKIT_API
IowKitSetLegacyOpenMode(ULONG legacyOpenMode);

// Get device product ID
USHORT IOWKIT_API
IowKitGetProductId(IOWKIT_HANDLE iowHandle);

// Get IO-Warrior serial number
BOOLEAN IOWKIT_API
IowKitGetSerialNumber(IOWKIT_HANDLE iowHandle, PWCHAR serialNumber);

// Set I/O timeout
BOOLEAN IOWKIT_API
IowKitSetTimeout(IOWKIT_HANDLE devHandle, ULONG timeout);

// Cancel pending I/O for given pipe
BOOLEAN IOWKIT_API
IowKitCancelIo(IOWKIT_HANDLE devHandle, ULONG numPipe);

#ifdef	__cplusplus
}
#endif

#endif
