VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "IO-Warrior sample application"
   ClientHeight    =   2160
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4455
   LinkTopic       =   "Form1"
   ScaleHeight     =   2160
   ScaleWidth      =   4455
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton IICReadButton 
      Caption         =   "Read from IIC"
      Height          =   495
      Left            =   1680
      TabIndex        =   8
      Top             =   1560
      Width           =   1455
   End
   Begin VB.TextBox TextVal7 
      Height          =   375
      Left            =   3000
      TabIndex        =   6
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal6 
      Height          =   375
      Left            =   2520
      TabIndex        =   5
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal5 
      Height          =   375
      Left            =   2040
      TabIndex        =   4
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal4 
      Height          =   375
      Left            =   1560
      TabIndex        =   3
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal3 
      Height          =   375
      Left            =   1080
      TabIndex        =   2
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal2 
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.CommandButton IICWriteButton 
      Caption         =   "Write to IIC"
      Height          =   495
      Left            =   120
      TabIndex        =   7
      Top             =   1560
      Width           =   1455
   End
   Begin VB.TextBox TextVal1 
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.Label Label2 
      Caption         =   "1st       2nd     3rd     4th      5th     6th      7th"
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   360
      Width           =   3255
   End
   Begin VB.Label ReadLabel 
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   1200
      Width           =   2655
   End
   Begin VB.Label Label1 
      Caption         =   "Bytes to write"
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   120
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' IO-Warrior handle
Dim iowHandle As Long
' Data buffer for writing to IIC
Dim data(7) As Byte

' Called when program starts and form is loaded
Private Sub Form_Load()
Dim Res As Long
    ' Initialize everything
    ' Open device
    iowHandle = IowKitOpenDevice()
    ' Fail if can't open
    If (iowHandle = 0) Then
        ' Exit from program
        MsgBox "Can not open device!", 0, "Error"
        End
    End If
    ' Enable IIC
    Res = IowKitEnableIIC(iowHandle, 1, 1)
    ' Check for error
    If (Res <> 8) Then
        ' Something is wrong, exit
        ReadLabel.Caption = "IIC not present"
        End
    End If
    ' XXX New: set timeout
    Res = IowKitSetTimeout(iowHandle, 1000)
End Sub

' Called when program exits
Private Sub Form_Unload(Cancel As Integer)
    ' Disable IIC
    Res = IowKitEnableIIC(iowHandle, 1, 0)
    ' Close IO-Warrior device
    IowKitCloseDevice (iowHandle)
End Sub

' Readbutton click handler
Private Sub IICReadButton_Click()
' IIC packet is 8 bytes long (1 byte is used for Report ID)
Dim iicPacket(7) As Byte
' Result and other variables
Dim Res As Long
Dim nBytes As Long
Dim nPending As Long
Dim sOK As String
    ' See IO-Warrior documentation for IIC packet specs
    ' Set "Read from IIC" Report ID number - 3
    iicPacket(0) = 3
    ' Get data from form and store it
    ' Get number of bytes read from IIC
    ' Remember, only values 1-255 are valid
    Value = Val(TextVal1.Text)
    If (Value < 1) Or (Value > 255) Then
        MsgBox "Invalid number of bytes to read " + TextVal1.Text, 0, "Error"
        Exit Sub
    End If
    ' Set number of bytes read from IIC
    iicPacket(1) = Value
    nBytes = Value
    ' Get IIC command
    Value = Val("&H" & TextVal2.Text)
    iicPacket(2) = Value
    ' Init rest of packet with zero
    iicPacket(3) = 0
    iicPacket(4) = 0
    iicPacket(5) = 0
    iicPacket(6) = 0
    iicPacket(7) = 0
    ' Write packet to IIC
    ' We initiate IIC read operation by writing this packet
    Res = IowKitWrite(iowHandle, 1, iicPacket(0), 8)
    ' Check error
    If (Res <> 8) Then
        Exit Sub
    End If
    ' Set pending bytes count
    nPending = nBytes
    ' Read data from IIC
    Do While (nPending > 0)
        Res = IowKitRead(iowHandle, 1, iicPacket(0), 8)
        ' Check packet
        If (iicPacket(0) <> 3) Then
            ' Wrong report ID
            Exit Sub
        End If
        ' OK, report ID is OK, check for error
        If (iicPacket(1) And &H80) <> 0 Then
            MsgBox "Read transaction aborted", 0, "IIC Error"
            Exit Do
        End If
        ' Get number of bytes read this time
        Res = iicPacket(1) And 7
        ' Decrement number of bytes to read left
        nPending = nPending - Res
        ' Do something with data
        ' Six bytes of data are stored in iicPacket(2)-iicPacket(7)
        TextVal1.Text = Hex$(iicPacket(2))
    Loop
    ReadLabel.Caption = "Read " & Str(nBytes) & " bytes"
End Sub

' Write button click handler
Private Sub IICWriteButton_Click()
' IIC packet is 8 bytes long (1 byte is used for Report ID)
Dim iicPacket(7) As Byte
Dim repPkt(7) As Byte
' Result
Dim Res As Long
Dim nBytes As Long
Dim sOK As String
    
    ReadLabel.Caption = "Writing to IIC"
    ReadLabel.Refresh
    ' See IO-Warrior documentation for IIC packet specs
    ' Set Write to IIC Report ID number - 2
    iicPacket(0) = 2
    ' Get data from form and store it
    Value = Val("&H" & TextVal1.Text)
    iicPacket(1) = Value
    ' Get number of bytes in this packet
    ' Number of bytes are stored in 3 lower bits of first byte
    nBytes = (Value And 7)
    Value = Val("&H" & TextVal2.Text)
    iicPacket(2) = Value
    Value = Val("&H" & TextVal3.Text)
    iicPacket(3) = Value
    Value = Val("&H" & TextVal4.Text)
    iicPacket(4) = Value
    Value = Val("&H" & TextVal5.Text)
    iicPacket(5) = Value
    Value = Val("&H" & TextVal6.Text)
    iicPacket(6) = Value
    Value = Val("&H" & TextVal7.Text)
    iicPacket(7) = Value
    ' Write to IIC
    Res = IowKitWrite(iowHandle, 1, iicPacket(0), 8)
    ' Check error
    'If (Res <> 8) Then
    '    Exit Sub
    'End If
    ' Read ack/error packet
    Res = IowKitRead(iowHandle, 1, iicPacket(0), 8)
    ' Handle packet
    ' Check if transaction is OK
    If (iicPacket(0) = 2) Then
        ' Report ID is OK
        ' Check other stuff
        If (iicPacket(1) And &H80) <> 0 Then
            ReadLabel.Caption = "IIC write error"
            ' Write error, exit from Sub
            Exit Sub
        End If
        Res = (iicPacket(1) And 7)
        sOK = ""
        ' Check if all bytes are ACKed
        If (Res < nBytes) Then
            sOK = " - less"
            Res = nBytes - Res
        End If
        ReadLabel.Caption = "IIC ack - " + Str(Res) + sOK + " bytes"
    Else
        ReadLabel.Caption = "Wrong IIC ack report ID!"
    End If
End Sub
