/****************************************************/
/*													*/
/*		Downloader for KeyWarrior OS X version		*/
/*													*/
/*		File: KeyWarriorUSB.cp						*/
/*													*/
/*		Version 1.0, 12.01.2003						*/
/*													*/
/*		1999-2003, Written by: Ralf Menssen		*/
/*													*/
/****************************************************/

#import <Cocoa/Cocoa.h>
//#include <unistd.h>
#include <mach/mach_port.h>

#include "KeyWarriorCommon.h"
#include "MyDocument.h"

//------------------------------------------------------------------
void RawDeviceRemoved(void *refCon, io_iterator_t iterator);
void RawDeviceAdded(void *refCon, io_iterator_t iterator);
void SignalHandler(int sigraised);
bool IsAKeyboardConnected (KeywarriorType *type, MyDocument *theDocument);
IOReturn DownLoad (IOUSBDeviceInterface **dev, unsigned char *theData, long dataLen, MyDocument *theDocument);


#define kOurVendorID	kCodeMercenaries
#define kOurProductID	kKeyWarrior
#define kMinKeyWarriorID	0x0100
#define kMaxKeyWarriorID	0x01FF
#define kMaxProductIDs	4
//------------------------------------------------------------------
IONotificationPortRef	gNotifyPort;
SInt32 keyWarriorProductID[kMaxProductIDs] = { 0x100, 0x110, 0x118, 0x120 };
io_iterator_t		gRawAddedIter[kMaxProductIDs], gRawRemovedIter[kMaxProductIDs];
IOUSBDeviceInterface 	**gDeviceInterface = NULL;
bool gSimulateKeyboardThere = NO;
bool gKeyboardConnectedLocal = false;
NSString *gKeyboardName;

//------------------------------------------------------------------

void RawDeviceRemoved(void *refCon, io_iterator_t iterator)
{
    kern_return_t	kr;
    io_service_t	obj;

    while ( (obj = IOIteratorNext(iterator)) )
    {
        printf("Raw device removed.\n");
        kr = IOObjectRelease(obj);
    }
	gDeviceInterface = NULL;
	gKeyboardConnectedLocal = false;
	if (gCurrentDocument)
		CheckForNecessaryDownload (gCurrentDocument);

}

//------------------------------------------------------------------
void RawDeviceAdded (void *refCon, io_iterator_t iterator)
{
    kern_return_t			kr;
    io_service_t			usbDevice;
    IOCFPlugInInterface 	**plugInInterface = NULL;
    IOUSBDeviceInterface 	**dev = NULL;
    HRESULT 				res;
    SInt32 					score;
    UInt16					vendor;
    UInt16					product;
    io_name_t devName;

    while ((usbDevice = IOIteratorNext(iterator)) != NULL)
    {
        printf("Raw device added.\n");
        kr = IOCreatePlugInInterfaceForService(usbDevice, kIOUSBDeviceUserClientTypeID, kIOCFPlugInInterfaceID, &plugInInterface, &score);
        kr = IORegistryEntryGetName(usbDevice, devName);
        if (kr)
        	gKeyboardName = @"???";
        else
        	gKeyboardName = [NSString stringWithFormat:@"%s", devName];
		kr = IOObjectRelease(usbDevice);				// done with the device object now that I have the plugin
        if ((kIOReturnSuccess != kr) || !plugInInterface)
        {
//          printf("unable to create a plugin (%08x)\n", kr);
            continue;
        }
            
        // I have the device plugin, I need the device interface
        res = (*plugInInterface)->QueryInterface(plugInInterface, CFUUIDGetUUIDBytes(kIOUSBDeviceInterfaceID), (LPVOID)&dev);
        (*plugInInterface)->Release(plugInInterface);			// done with this
        if (res || !dev)
        	{
			printf("couldn't create a device interface (%08x)\n", (int) res);
            continue;
        	}
        // technically should check these kr values
        kr = (*dev)->GetDeviceVendor(dev, &vendor);
        kr = (*dev)->GetDeviceProduct(dev, &product);
        if ((vendor != kCodeMercenaries) || ((product & 0xFF00) != kKeyWarrior))
        	{
            (void) (*dev)->Release(dev);
            return false;
        	}
        gDeviceInterface = dev;
        gKeyboardConnectedLocal = true;
        gNotYetDownLoaded = true;
		if (((product & 0x0010)) == 0x10)
			{
			gKeyboardType = kTypeOperator;
			}
		else
			{
			gKeyboardType = kTypeFlex;
			}
		if (gCurrentDocument)
			CheckForNecessaryDownload (gCurrentDocument);
        kr = (*dev)->Release(dev);
        return true
    }
}

//------------------------------------------------------------------
#if 0
void SignalHandler (int sigraised)
{
SInt32 i;
    printf("\nInterrupted\n");
   
    // Clean up here
    IONotificationPortDestroy(gNotifyPort);

	for (i = 0; i < kMaxProductIDs; i++)
		{
	    if (gRawAddedIter[i]) 
	    	{
	        IOObjectRelease(gRawAddedIter[i]);
	        gRawAddedIter[i] = 0;
	    	}
	    if (gRawRemovedIter[i]) 
	    	{
	        IOObjectRelease(gRawRemovedIter[i]);
	        gRawRemovedIter[i] = 0;
	    	}
	    }
    exit(0);
}
#endif

#if 0
//------------------------------------------------------------------
IOReturn DownLoad (IOUSBDeviceInterface **dev, unsigned char *theData, long dataLen, MyDocument *theDocument)
{
unsigned char buf[6];
unsigned short i;
#ifndef SIMULATION
IOReturn ret;
IOUSBDevRequest request;
#endif
// Setup the progress bar
[theDocument SetDownloadProgressValue: (double)0.0];
[theDocument SetMaxDownloadProgressValue: (double) dataLen];
[theDocument SetDownloadProgressValue: (double)0.0];

for (i = 0; i < dataLen; i += 4)			// i contains index to table
	{
	// --- Transfer Data to buffer ---
	if (dataLen > 256)			// Large table
		{
		buf[0] = i & 0x00FF;	// Low byte of table index
		buf[1] = i >> 8;		// High byte of table index
		buf[2] = theData[i];
		buf[3] = theData[i + 1];
		buf[4] = theData[i + 2];
		buf[5] = theData[i + 3];
		}
	else
		{						// Small table
		buf[0] = i;				// Table index
		buf[1] = theData[i];
		buf[2] = theData[i + 1];
		buf[3] = theData[i + 2];
		buf[4] = theData[i + 3];
		}
    
#ifdef SIMULATION
	[theDocument DelayForMillisecs : 50];
#else
    // Assert reset
    request.bmRequestType = 0x21;
    request.bRequest = 0x09;
    request.wValue = 0x03;
    request.wIndex = 0;
    request.wLength = (dataLen > 256) ? 6 : 5;
    request.pData = buf;
    ret = (*dev)->DeviceRequest (dev, &request);
	if (ret != kIOReturnSuccess)									// Check for error
		return ret;
#endif
	[theDocument SetDownloadProgressValue: (double) i + 4.0];
	}
[theDocument UpdateKeyboardWindow];
NSBeep();
[theDocument UpdateKeyboardWindow];
return kIOReturnSuccess;
}

//------------------------------------------------------------------
bool IsAKeyboardConnected (KeywarriorType *type, MyDocument *theDocument)	// returns the Name if yes
{
#ifdef SIMULATION
*type = kTypeOperator;
if(gSimulateKeyboardThere)
	{
	gKeyBoardName =  @"Operator (large table)";
	return true;
	}
else
	return false;
#endif

gKeyboardConnected = gKeyboardConnectedLocal;
if (gKeyboardConnectedLocal)
	{
	*type = gKeyboardType;
	}
return gKeyboardConnectedLocal;

}
#endif

#if 0
//------------------------------------------------------------------
void CheckForNecessaryDownload (MyDocument *theDocument)
{
IOReturn ret;

if (gKeyboardConnectedLocal && !gKeyboardConnected)
	gNotYetDownLoaded = true;
if (gKeyboardConnectedLocal && gWeHaveData && gNotYetDownLoaded)
	{
	gKeyboardConnected = gKeyboardConnectedLocal;

	if (theDocument)
		{
		gNotYetDownLoaded = false;
		[theDocument SetKeyboardConnected: @"connected"];
		[theDocument SetKeyboardType: gKeyboardName];
		if (gKeyboardType != gDataType)
			{
			if (gDataType == kTypeFlex)
		        NSRunAlertPanel (@"Keyboard and data have different types!",
		                    @"File has a small table", @"OK", NULL, NULL);
			else
		        NSRunAlertPanel (@"Keyboard and data have different types!",
		                    @"File has a large table", @"OK", NULL, NULL);
			return;
			}
		if ((gKeyboardType != kTypeFlex) && (gKeyboardType != kTypeOperator))
			return;
		[theDocument SetDownloadStatus: @"Downloading data..."];
		[theDocument UpdateKeyboardWindow];
		ret = DownLoad (gDeviceInterface, gTableBuf, gTableLen, theDocument);
		if (ret != kIOReturnSuccess)
			{
			[theDocument SetDownloadStatus: @"An error occured while downloading"];
			NSRunAlertPanel (@"Download error", [[[NSString alloc] autorelease ] initWithFormat:
			        @"Downloading failed because of err:  #%ld.", (long) ret], @"OK", NULL, NULL);
			}
		else
			[theDocument SetDownloadStatus: @"Updated successfully"];
		}
	}
else
	{
	if (!gKeyboardConnectedLocal && gKeyboardConnected && theDocument)
		{
		[theDocument SetKeyboardConnected: @"--- not connected ---"];
		[theDocument SetKeyboardType: @"--- undecided ---"];
		[theDocument SetDownloadStatus: @"waiting for a new keyboard"];
		[theDocument SetDownloadProgressValue: (double)0.0];		
		}
	gKeyboardConnected = gKeyboardConnectedLocal;
	}
}

//------------------------------------------------------------------
int InitializeKeyWarriorNotifier ()
{
    mach_port_t 			masterPort;
    CFMutableDictionaryRef 	matchingDict[kMaxProductIDs];
    CFRunLoopSourceRef		runLoopSource;
    kern_return_t			kr;
    SInt32					usbVendor = kOurVendorID;
    SInt32					usbProduct, i;
    sig_t					oldHandler;

    // pick up command line arguments
    // Set up a signal handler so we can clean up when we're interrupted from the command line
    // Otherwise we stay in our run loop forever.
    oldHandler = signal(SIGINT, SignalHandler);
    if (oldHandler == SIG_ERR)
		{
//        printf("Could not establish new signal handler");
		}
        
    // first create a master_port for my task
    kr = IOMasterPort(MACH_PORT_NULL, &masterPort);
    if (kr || !masterPort)
    {
//        printf("ERR: Couldn't create a master IOKit Port(%08x)\n", kr);
        return -1;
    }

//    printf("Looking for devices matching vendor ID=%ld and product ID=%ld or product ID=%ld\n", usbVendor, usbProduct, usbProduct2);
	for (i = 0; i < kMaxProductIDs; i++)
		{
		usbProduct = keyWarriorProductID[i];
	    // Set up the matching criteria for the devices we're interested in
	    matchingDict[i] = IOServiceMatching(kIOUSBDeviceClassName);	// Interested in instances of class IOUSBDevice and its subclasses
	    if (!matchingDict)
	    {
	        printf("Can't create a USB matching dictionary\n");
	        mach_port_deallocate(mach_task_self(), masterPort);
	        return -1;
	    }
	    
	    // Add our vendor and product IDs to the matching criteria
	    CFDictionarySetValue (matchingDict[i], CFSTR(kUSBVendorID), CFNumberCreate(kCFAllocatorDefault,
																kCFNumberSInt32Type, &usbVendor));
		CFDictionarySetValue (matchingDict[i], CFSTR(kUSBProductID), CFNumberCreate(kCFAllocatorDefault,
																kCFNumberSInt32Type, &usbProduct)); 
		}
    // Create a notification port and add its run loop event source to our run loop
    // This is how async notifications get set up.
    gNotifyPort = IONotificationPortCreate(masterPort);
    runLoopSource = IONotificationPortGetRunLoopSource(gNotifyPort);
    
    CFRunLoopAddSource(CFRunLoopGetCurrent(), runLoopSource, kCFRunLoopDefaultMode);
    
    // Retain additional references because we use this same dictionary with two calls to 
    // IOServiceAddMatchingNotification, each of which consumes one reference.
	for (i = 0; i < kMaxProductIDs; i++)
		{
		usbProduct = keyWarriorProductID[i];
 	 	matchingDict[i] = (CFMutableDictionaryRef) CFRetain (matchingDict[i]); 
    
	    // Now set up two notifications, one to be called when a raw device is first matched by I/O Kit, and the other to be
	    // called when the device is terminated.
	    kr = IOServiceAddMatchingNotification (gNotifyPort, kIOFirstMatchNotification, matchingDict[i],
	                                            RawDeviceAdded,  NULL, &(gRawAddedIter[i]));
		if (kr)
			printf ("Can't do IOServiceAddMatchingNotification Add #%ld (err = %ld)\n", usbProduct, (long) kr);
	    RawDeviceAdded (NULL, gRawAddedIter[i]);	// Iterate once to get already-present devices and
												// arm the notification
	 
	    kr = IOServiceAddMatchingNotification (gNotifyPort, kIOTerminatedNotification, matchingDict[i],
	                                          RawDeviceRemoved, NULL, &(gRawRemovedIter[i]));
		if (kr)
			printf ("Can't do IOServiceAddMatchingNotification Add #%ld (err = %ld)\n", usbProduct, (long) kr);
	    RawDeviceRemoved(NULL, gRawRemovedIter[usbProduct]);	// Iterate once to arm the notification
	    }                                        
    // Now done with the master_port
    mach_port_deallocate(mach_task_self(), masterPort);
    masterPort = 0;

    return 0;
}
#endif

//------------------------------------------------------------------
#if 0
int InitializeKeyWarriorNotifier ()
{
    mach_port_t 		masterPort;
    CFMutableDictionaryRef 	matchingDict;
    CFRunLoopSourceRef		runLoopSource;
    kern_return_t		kr;
    SInt32			usbVendor = kOurVendorID;
    SInt32			usbProduct = 0x120;
    sig_t			oldHandler;
    
    // pick up command line arguments
    // Set up a signal handler so we can clean up when we're interrupted from the command line
    // Otherwise we stay in our run loop forever.
    oldHandler = signal(SIGINT, SignalHandler);
    if (oldHandler == SIG_ERR)
		{
//        printf("Could not establish new signal handler");
		}
        
    // first create a master_port for my task
    kr = IOMasterPort(MACH_PORT_NULL, &masterPort);
    if (kr || !masterPort)
    {
//        printf("ERR: Couldn't create a master IOKit Port(%08x)\n", kr);
        return -1;
    }

//    printf("Looking for devices matching vendor ID=%ld and product ID=%ld or product ID=%ld\n", usbVendor, usbProduct, usbProduct2);

    // Set up the matching criteria for the devices we're interested in
    matchingDict = IOServiceMatching(kIOUSBDeviceClassName);	// Interested in instances of class IOUSBDevice and its subclasses
    if (!matchingDict)
    {
//        printf("Can't create a USB matching dictionary\n");
        mach_port_deallocate(mach_task_self(), masterPort);
        return -1;
    }
    
    // Add our vendor and product IDs to the matching criteria
    CFDictionarySetValue (matchingDict, CFSTR(kUSBVendorID), CFNumberCreate(kCFAllocatorDefault,
															kCFNumberSInt32Type, &usbVendor));
	CFDictionarySetValue (matchingDict, CFSTR(kUSBProductID), CFNumberCreate(kCFAllocatorDefault,
															kCFNumberSInt32Type, &usbProduct)); 
    // Create a notification port and add its run loop event source to our run loop
    // This is how async notifications get set up.
    gNotifyPort = IONotificationPortCreate(masterPort);
    runLoopSource = IONotificationPortGetRunLoopSource(gNotifyPort);
    
    CFRunLoopAddSource(CFRunLoopGetCurrent(), runLoopSource, kCFRunLoopDefaultMode);
    
    // Retain additional references because we use this same dictionary with two calls to 
    // IOServiceAddMatchingNotification, each of which consumes one reference.
 	  matchingDict = (CFMutableDictionaryRef) CFRetain (matchingDict); 
    
    // Now set up two notifications, one to be called when a raw device is first matched by I/O Kit, and the other to be
    // called when the device is terminated.

    kr = IOServiceAddMatchingNotification (gNotifyPort, kIOFirstMatchNotification, matchingDict,
                                            RawDeviceAdded,  NULL, &gRawAddedIter);
    RawDeviceAdded (NULL, gRawAddedIter);	// Iterate once to get already-present devices and
											// arm the notification
 
    kr = IOServiceAddMatchingNotification (gNotifyPort, kIOTerminatedNotification, matchingDict,
                                          RawDeviceRemoved, NULL, &gRawRemovedIter);
//    RawDeviceRemoved(NULL, gRawRemovedIter);	// Iterate once to arm the notification
                                            
    // Now done with the master_port
    mach_port_deallocate(mach_task_self(), masterPort);
    masterPort = 0;

    return 0;
}

#endif
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
