//
// multdev.cpp
// IO-Warrior SDK library
//
// multiple devices support functions
//

#include "stdafx.h"
#include "iowkit.h"
#include "iowdev.h"
#include "debug.h"

#pragma pack(1)

// Legacy open mode management
BOOLEAN IOWKIT_API
IowKitSetLegacyOpenMode(ULONG legacyOpenMode)
{
	// Check parameter
	// Now we only support opening one interface for legacy device
	// either simple or complex
	if ((legacyOpenMode == IOW_OPEN_SIMPLE) || (legacyOpenMode == IOW_OPEN_COMPLEX)) {
		// Save new open mode
		iowLegacyOpenMode = legacyOpenMode;

		return TRUE;
	}

	// We don't support other open modes
	return FALSE;
}

// Return number of devices
ULONG IOWKIT_API
IowKitGetNumDevs(VOID)
{
	return iowNumDevices;
}

// Get Nth device handle
IOWKIT_HANDLE IOWKIT_API
IowKitGetDeviceHandle(ULONG numDevice)
{
	// Fail if device number is too big
	if ((numDevice < 1) || (numDevice > iowNumDevices)) {
		// TODO: SetLastError()?
		return NULL;
	}

	// Return device handle
	return &iowHandles[numDevice-1];
}

// Get device product ID
USHORT IOWKIT_API
IowKitGetProductId(IOWKIT_HANDLE iowHandle)
{
	PIOWKIT_DEVICE_INTERNAL iowDev = (PIOWKIT_DEVICE_INTERNAL) iowHandle;

	__try {
	// Check devHandle
	if (iowDev == NULL || (iowDev->cookie != IOWKIT_DEVICE_COOKIE)) {
		return 0;
	}
	}
	__except ( EXCEPTION_EXECUTE_HANDLER ) {
		return 0;
	}

	// OK, now we can return IOW Product ID
	return iowDev->productId;
}

BOOLEAN IOWKIT_API
IowKitGetSerialNumber(IOWKIT_HANDLE iowHandle, PWCHAR serialNumber)
{
	PIOWKIT_DEVICE_INTERNAL iowDev = (PIOWKIT_DEVICE_INTERNAL) iowHandle;

	__try {
		// Fail if handle is invalid
		if (iowDev == NULL || (iowDev->cookie != IOWKIT_DEVICE_COOKIE)) {
			return FALSE;
		}
		// Zero length S/N means IOW doesn't have S/N
		serialNumber[0] = 0;
		// Copy serial number
		if (!iowDev->isLegacy) {
			memcpy(serialNumber, iowDev->serialNumber, sizeof(iowDev->serialNumber));

			return TRUE;
		}
	}
	__except ( EXCEPTION_EXECUTE_HANDLER ) {
	}

	return FALSE;
}
