//
// async.cpp
//
// Async IOW notification support
//

#include "stdafx.h"
#include "iowkit.h"
#include "iowdev.h"
#include "debug.h"

#pragma	pack(1)

// Register Window message callback
// Specified window will get specified message with LPARAM set to
// current 32-bit value when something changes
BOOLEAN IOWKIT_API
IowKitRegisterMsgCallback(IOWKIT_HANDLE iowHandle, HWND hWnd, UINT Msg)
{
	PIOWKIT_DEVICE_INTERNAL iowDev;
	DWORD rc;

	// Get iowDev
	iowDev = (PIOWKIT_DEVICE_INTERNAL) iowHandle;
	// XXX check for HWND_BROADCAST???
	// Get mutex
	rc = WaitForSingleObject(iowDev->bufMutex, INFINITE);
	// Save HWND & Msg
	iowDev->callbackWnd = hWnd;
	iowDev->callbackMsg = Msg;
	// Release mutex
	ReleaseMutex(iowDev->bufMutex);

	return TRUE;
}

BOOLEAN IOWKIT_API
IowKitUnregisterMsgCallback(IOWKIT_HANDLE iowHandle, HWND hWnd, UINT Msg)
{
	return TRUE;
}

// Process all user callbacks.
// Called with bufMutex held - this is internal function.
VOID
IowKitProcessCallbacks(PIOWKIT_DEVICE_INTERNAL iowDev)
{
	// Send message to window, if any
	if (iowDev->callbackWnd != NULL) {
		PostMessage(iowDev->callbackWnd, iowDev->callbackMsg, 0, iowDev->lastValue);
	}
}
