//
// ioblink.c - Blinking LEDs sample
//

#include "stdafx.h"

int main(int argc, char* argv[])
{
	IOWKIT_HANDLE ioHandle;
	int i, bits, nWritten;
	IOWKIT_REPORT rep;

	// Open device
	ioHandle = IowKitOpenDevice();
	// Check for failure
	if (ioHandle == NULL) {
		printf("Failed to open device\n");
		goto out;
	}
	// Init report
	// Report ID 0 is for writing to 32 input/output pins
	rep.ReportID = 0;
	printf("Blinking LEDs...\n");
	// Blinking'
	for (i = 0; i < 100; i++) {
		// Generate random 8 bits
		bits = (rand() & 1) << 7;
		bits |= (rand() & 1) << 6;
		bits |= (rand() & 1) << 5;
		bits |= (rand() & 1) << 4;
		bits |= (rand() & 1) << 3;
		bits |= (rand() & 1) << 2;
		bits |= (rand() & 1) << 1;
		bits |= (rand() & 1);
		// Shift them to high 32 bits
		rep.Value = bits << 24;
		// Write to IO-Warrior
		nWritten = IowKitWrite(ioHandle, 0, (PCHAR) &rep, sizeof(rep));
		if (nWritten != 5) {
			printf("No write, err %d %d\n", nWritten, GetLastError());
		}
		// Sleep for 25ms
		Sleep(25);
	}
	printf("Blinking complete\n");
	// All ones is off
	rep.Value = ~0UL;
	// Set LEDs off
	IowKitWrite(ioHandle, 0, (PCHAR) &rep, sizeof(rep));
	// Close device
	IowKitCloseDevice(ioHandle);
out:

	return 0;
}

