// This demo needs the component CoolTrayIcon.

unit JoyWaMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,
  Dialogs, JvHidControllerClass, CoolTrayIcon, Menus,
  StdCtrls, Spin;

type
  TJoyMainForm = class(TForm)
    CoolTrayIcon: TCoolTrayIcon;
    TrayPopup: TPopupMenu;
    Konfiguration1: TMenuItem;
    Beenden1: TMenuItem;
    FromChannel: TLabel;
    ToButtons: TLabel;
    CH12_34: TCheckBox;
    CH3_4: TCheckBox;
    CH1_2: TCheckBox;
    Inv5: TCheckBox;
    Inv4: TCheckBox;
    Inv3: TCheckBox;
    Inv2: TCheckBox;
    Inv1: TCheckBox;
    HidCtl: TJvHidDeviceController;
    ChannelToButtons: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Konfiguration1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure HidCtlDeviceChange(Sender: TObject);
    procedure HidCtlDeviceUnplug(HidDev: TJvHidDevice);
    procedure CheckBoxClick(Sender: TObject);
  private
    FCanClose: Boolean;
    procedure WMQueryEndSession(var Msg: TMessage); message WM_QUERYENDSESSION;
    procedure WMEndSession(var Msg: TMessage); message WM_ENDSESSION;
  public
    JoyDev: TJvHidDevice;
  end;

var
  JoyMainForm: TJoyMainForm;

implementation


const
  cCodeMercsVendorID = 1984;
  cJoyWarriorRCProductID = $1110;

type
  TJW24RCOutputReport = packed record
    ReportID: Byte;
    OptionBits: Byte;
    ChannelButtons: Byte;
  end;

{$R *.dfm}

procedure TJoyMainForm.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  FCanClose := False;
  // place the main window above the tray area
  for I := 0 to Screen.MonitorCount - 1 do
    if Screen.Monitors[I].Primary then
    begin
      Top  := Screen.Monitors[I].WorkareaRect.Bottom - Height;
      Left := Screen.Monitors[I].WorkareaRect.Right  - Width;
      Break;
    end;
end;

procedure TJoyMainForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := FCanClose;
  if not CanClose then
    CoolTrayIcon.HideMainForm;
end;

procedure TJoyMainForm.Konfiguration1Click(Sender: TObject);
begin
  CoolTrayIcon.ShowMainForm;
end;

procedure TJoyMainForm.Beenden1Click(Sender: TObject);
begin
  FCanClose := True;
  HidCtl.CheckIn(JoyDev);
  JoyDev := nil;
  Close;
end;

function JoyCheck(HidDev: TJvHidDevice): Boolean; stdcall;
begin
  // find the correct interface of JoyWarrior RC
  Result := (HidDev.Attributes.VendorID = cCodeMercsVendorID) and
    (HidDev.Attributes.ProductID = cJoyWarriorRCProductID) and
    (HidDev.Caps.OutputReportByteLength = 3);
end;

procedure TJoyMainForm.HidCtlDeviceChange(Sender: TObject);
begin
  if not Assigned(JoyDev) then
    if HidCtl.CheckOutByCallback(JoyDev, JoyCheck) then
    begin
      Inv1.Enabled := True;
      Inv2.Enabled := True;
      Inv3.Enabled := True;
      Inv4.Enabled := True;
      Inv5.Enabled := True;
      CH1_2.Enabled := True;
      CH3_4.Enabled := True;
      CH12_34.Enabled := True;
      ChannelToButtons.Enabled := True;
      FromChannel.Enabled := True;
      ToButtons.Enabled := True;
      CheckBoxClick(Self);
    end;
end;

procedure TJoyMainForm.HidCtlDeviceUnplug(HidDev: TJvHidDevice);
begin
  if Assigned(JoyDev) then
  begin
    Inv1.Enabled := False;
    Inv2.Enabled := False;
    Inv3.Enabled := False;
    Inv4.Enabled := False;
    Inv5.Enabled := False;
    CH1_2.Enabled := False;
    CH3_4.Enabled := False;
    CH12_34.Enabled := False;
    ChannelToButtons.Enabled := False;
    FromChannel.Enabled := False;
    ToButtons.Enabled := False;
    HidCtl.CheckIn(JoyDev);
    JoyDev := nil;
  end;
end;

procedure TJoyMainForm.CheckBoxClick(Sender: TObject);
var
  Report: TJW24RCOutputReport;
  BytesWritten: Cardinal;
begin
  with Report do
  begin
    ReportID := 0;
    // translate checkboxes to bits
    OptionBits := 0;
    OptionBits := OptionBits or (Ord(Inv1.Checked)    shl 0);
    OptionBits := OptionBits or (Ord(Inv2.Checked)    shl 1);
    OptionBits := OptionBits or (Ord(Inv3.Checked)    shl 2);
    OptionBits := OptionBits or (Ord(Inv4.Checked)    shl 3);
    OptionBits := OptionBits or (Ord(Inv5.Checked)    shl 4);
    OptionBits := OptionBits or (Ord(CH1_2.Checked)   shl 5);
    OptionBits := OptionBits or (Ord(CH3_4.Checked)   shl 6);
    OptionBits := OptionBits or (Ord(CH12_34.Checked) shl 7);
    ChannelButtons := Byte(ChannelToButtons.Value);
  end;
  JoyDev.WriteFile(Report, SizeOf(TJW24RCOutputReport), BytesWritten);
end;

procedure TJoyMainForm.WMQueryEndSession(var Msg: TMessage);
begin
  // allow close of program on shutdown
  FCanClose := True;
  Msg.Result := 1;
end;

procedure TJoyMainForm.WMEndSession(var Msg: TMessage);
begin
  if Msg.WParam = 1 then
    Msg.Result := 0;
end;

end.
