//---------------------------------------------------------------------------

#ifndef IOIRMainH
#define IOIRMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "JvHidControllerClass.hpp"
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
#define cCodeMercenariesVID 0x07C0
#define cIOWarriorPID1      0x1500
#define cIOWarriorPID2      0x1501
#define cIRCommand          0x0C
//---------------------------------------------------------------------------
#pragma pack(push, 1)
  typedef struct
  {
    unsigned char Command;   // data part 0..63 of IR RC5 code
    unsigned char Address;   // device ID part 0..31 of IR RC5 code
    unsigned char Empty[5];  // 5 bytes containing 0
  }
  TIOWarriorIRInputReport;

  typedef struct
  {
    unsigned char ReportID;   // needed for output
    unsigned char IOData[7];  // 7 Bytes for IO-Warrior
  }
  TIOWarriorIROutputReport;
#pragma pack(pop)
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
        TLabel *IOWarriorDetected;
        TJvHidDeviceController *HidCtl;
        TLabel *Description;
        TListView *CodeList;
        void __fastcall HidCtlDeviceChange(TObject *Sender);
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall HidCtlDeviceData(TJvHidDevice *HidDev,
          BYTE ReportID, const Pointer Data, WORD Size);
        void __fastcall CodeListDblClick(TObject *Sender);
private:	// User declarations
public:		// User declarations
        TJvHidDevice *IOWarrior;
        void __fastcall UpdateControls(void);
        __fastcall TMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
