//---------------------------------------------------------------------------

#ifndef IOMainH
#define IOMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "JvHidControllerClass.hpp"
#include <Buttons.hpp>
//---------------------------------------------------------------------------
#define cCodeMercenariesVID 0x07C0
#define cIOWarriorPID       0x1500
#define cLEDByte            3

#pragma pack(push, 1)
  typedef struct
  {
    unsigned char ReportID;   // all reports have a ReportID
    unsigned char IOBits[4];  // 32 bits to read and write
  }
  TIOWarriorIOReport;
#pragma pack(pop)
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
        TJvHidDeviceController *HidCtl;
        TLabel *IOWarriorDetected;
        TLabel *InputBits;
        TSpeedButton *LED0;
        TSpeedButton *LED1;
        TSpeedButton *LED2;
        TSpeedButton *LED3;
        TSpeedButton *LED4;
        TSpeedButton *LED5;
        TSpeedButton *LED6;
        TSpeedButton *LED7;
        TSpeedButton *BlockingRead;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall HidCtlDeviceChange(TObject *Sender);
        void __fastcall LEDClick(TObject *Sender);
        void __fastcall BlockingReadClick(TObject *Sender);
private:	// User declarations
public:		// User declarations
        TSpeedButton *LEDs[8];
        TJvHidDevice *IOWarrior;
        TIOWarriorIOReport IOWarriorOutputReport;
        __fastcall TMainForm(TComponent* Owner);
        void  __fastcall UpdateControls(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
