#include "UsagesInfo.h"

void UsageAndUsagePageText(TUsage UsagePage, TUsage Usage,
 AnsiString *UsagePageText, AnsiString *UsageText)
{
  *UsagePageText = "";
  *UsageText = "";
  switch(UsagePage)
  {
    case HID_USAGE_PAGE_UNDEFINED:
      *UsagePageText = "Undefined";
      break;
    case HID_USAGE_PAGE_GENERIC:
      *UsagePageText = "Generic Desktop";
      switch(Usage)
      {
        case HID_USAGE_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_GENERIC_POINTER:
          *UsageText = "Pointing Device";
          break;
        case HID_USAGE_GENERIC_MOUSE:
          *UsageText = "Mouse";
          break;
        case HID_USAGE_GENERIC_RESERVED1:
          *UsageText = "Reserved";
          break;
        case HID_USAGE_GENERIC_JOYSTICK:
          *UsageText = "Joystick";
          break;
        case HID_USAGE_GENERIC_GAMEPAD:
          *UsageText = "Gamepad";
          break;
        case HID_USAGE_GENERIC_KEYBOARD:
          *UsageText = "Keyboard";
          break;
        case HID_USAGE_GENERIC_KEYPAD:
          *UsageText = "Keypad";
          break;
        case HID_USAGE_GENERIC_MULTIAXIS:
          *UsageText = "Multi-Axis";
          break;
        case HID_USAGE_GENERIC_X:
          *UsageText = "X Axis";
          break;
        case HID_USAGE_GENERIC_Y:
          *UsageText = "Y Axis";
          break;
        case HID_USAGE_GENERIC_Z:
          *UsageText = "Z Axis";
          break;
        case HID_USAGE_GENERIC_RX:
          *UsageText = "Relative X Axis";
          break;
        case HID_USAGE_GENERIC_RY:
          *UsageText = "Relative Y Axis";
          break;
        case HID_USAGE_GENERIC_RZ:
          *UsageText = "Relative Z Axis";
          break;
        case HID_USAGE_GENERIC_SLIDER:
          *UsageText = "Slider";
          break;
        case HID_USAGE_GENERIC_DIAL:
          *UsageText = "Dial";
          break;
        case HID_USAGE_GENERIC_WHEEL:
          *UsageText = "Wheel";
          break;
        case HID_USAGE_GENERIC_HATSWITCH:
          *UsageText = "Hat Switch";
          break;
        case HID_USAGE_GENERIC_COUNTED_BUFFER:
          *UsageText = "Counted Buffer";
          break;
        case HID_USAGE_GENERIC_BYTE_COUNT:
          *UsageText = "Byte Count";
          break;
        case HID_USAGE_GENERIC_MOTION_WAKEUP:
          *UsageText = "Motion Wakeup";
          break;
        case HID_USAGE_GENERIC_START:
          *UsageText = "Start";
          break;
        case HID_USAGE_GENERIC_SELECT:
          *UsageText = "Select";
          break;
        case HID_USAGE_GENERIC_RESERVED2:
          *UsageText = "Reserved";
          break;
        case HID_USAGE_GENERIC_VX:
          *UsageText = "Velocity X";
          break;
        case HID_USAGE_GENERIC_VY:
          *UsageText = "Velocity Y";
          break;
        case HID_USAGE_GENERIC_VZ:
          *UsageText = "Velocity Z";
          break;
        case HID_USAGE_GENERIC_VBRX:
          *UsageText = "Velocity Brake X";
          break;
        case HID_USAGE_GENERIC_VBRY:
          *UsageText = "Velocity Brake Y";
          break;
        case HID_USAGE_GENERIC_VBRZ:
          *UsageText = "Velocity Brake Z";
          break;
        case HID_USAGE_GENERIC_VNO:
          *UsageText = "Vno";
          break;
        case HID_USAGE_FEATURE_NOTIFICATION:
          *UsageText = "Feature Notification";
          break;
        case HID_USAGE_GENERIC_SYSTEM_CTL:
          *UsageText = "System Control";
          break;
        case HID_USAGE_GENERIC_SYSCTL_POWER:
          *UsageText = "System Control Power Down";
          break;
        case HID_USAGE_GENERIC_SYSCTL_SLEEP:
          *UsageText = "System Control Sleep";
          break;
        case HID_USAGE_GENERIC_SYSCTL_WAKE:
          *UsageText = "System Control Wake Up";
          break;
        case HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU:
          *UsageText = "System Control Context Menu";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MAIN_MENU:
          *UsageText = "System Control Main Menu";
          break;
        case HID_USAGE_GENERIC_SYSCTL_APP_MENU:
          *UsageText = "System Control App Menu";
          break;
        case HID_USAGE_GENERIC_SYSCTL_HELP_MENU:
          *UsageText = "System Control Help Menu";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_EXIT:
          *UsageText = "System Control Menu Exit";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_SELECT:
          *UsageText = "System Control Menu Select";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT:
          *UsageText = "System Control Menu Right";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_LEFT:
          *UsageText = "System Control Menu Left";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_UP:
          *UsageText = "System Control Menu Up";
          break;
        case HID_USAGE_GENERIC_SYSCTL_MENU_DOWN:
          *UsageText = "System Control Menu Down";
          break;
        case HID_USAGE_GENERIC_SYSCTL_COLD_RESTART:
          *UsageText = "System Control Cold Restart";
          break;
        case HID_USAGE_GENERIC_SYSCTL_WARM_RESTART:
          *UsageText = "System Control Warm Restart";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DPAD_UP:
          *UsageText = "System Control DPad Up";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DPAD_DOWN:
          *UsageText = "System Control DPad Down";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DPAD_RIGHT:
          *UsageText = "System Control DPad Right";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DPAD_LEFT:
          *UsageText = "System Control DPad Left";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DOCK:
          *UsageText = "System Control Dock";
          break;
        case HID_USAGE_GENERIC_SYSCTL_UNDOCK:
          *UsageText = "System Control Undock";
          break;
        case HID_USAGE_GENERIC_SYSCTL_SETUP:
          *UsageText = "System Control Setup";
          break;
        case HID_USAGE_GENERIC_SYSCTL_BREAK:
          *UsageText = "System Control Break";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DEBUGGER_BREAK:
          *UsageText = "System Control Debugger Break";
          break;
        case HID_USAGE_GENERIC_SYSCTL_APP_BREAK:
          *UsageText = "System Control Application Break";
          break;
        case HID_USAGE_GENERIC_SYSCTL_APP_DEBUGGER_BREAK:
          *UsageText = "System Control Application Debugger Break";
          break;
        case HID_USAGE_GENERIC_SYSCTL_SYSTEM_SPEAKER_MUTE:
          *UsageText = "System Control Speaker Mute";
          break;
        case HID_USAGE_GENERIC_SYSCTL_SYSTEM_HIBERNATE:
          *UsageText = "System Control Hibernate";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_INVERT:
          *UsageText = "System Control Invert Display";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_INTERNAL:
          *UsageText = "System Control Internal Display";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_EXTERNAL:
          *UsageText = "System Control External Display";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_BOTH:
          *UsageText = "System Control Both Displays";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_DUAL:
          *UsageText = "System Control Dual Displays";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_TOGGLE_INT_EXT:
          *UsageText = "System Control Toggle Internal/External Display";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_SWAP:
          *UsageText = "System Control Swap Primary/Secondary Displays";
          break;
        case HID_USAGE_GENERIC_SYSCTL_DISPLAY_LCD_AUTOSCALE:
          *UsageText = "System Control LCD Autoscale Display";
          break;
      }
      break;
    case HID_USAGE_PAGE_SIMULATION:
      *UsagePageText = "Simulation";
      switch(Usage)
      {
        case HID_USAGE_SIMULATION_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_SIMULATION_FLIGHT:
          *UsageText = "Flight";
          break;
        case HID_USAGE_SIMULATION_AUTOMOBILE:
          *UsageText = "Automobile";
          break;
        case HID_USAGE_SIMULATION_TANK:
          *UsageText = "Tank";
          break;
        case HID_USAGE_SIMULATION_SPACESHIP:
          *UsageText = "Spaceship";
          break;
        case HID_USAGE_SIMULATION_SUBMARINE:
          *UsageText = "Submarine";
          break;
        case HID_USAGE_SIMULATION_SAILING:
          *UsageText = "Sailing";
          break;
        case HID_USAGE_SIMULATION_MOTORCYCLE:
          *UsageText = "Motorcycle";
          break;
        case HID_USAGE_SIMULATION_SPORTS:
          *UsageText = "Sports";
          break;
        case HID_USAGE_SIMULATION_AIRPLANE:
          *UsageText = "Airplane";
          break;
        case HID_USAGE_SIMULATION_HELICOPTER:
          *UsageText = "Helicopter";
          break;
        case HID_USAGE_SIMULATION_MAGIC_CARPET:
          *UsageText = "Magic Carpet";
          break;
        case HID_USAGE_SIMULATION_BICYCLE:
          *UsageText = "Bicycle";
          break;
        case HID_USAGE_SIMULATION_FLIGHT_CONTROL_STICK:
          *UsageText = "Flight Control Stick";
          break;
        case HID_USAGE_SIMULATION_FLIGHT_STICK:
          *UsageText = "Flight Stick";
          break;
        case HID_USAGE_SIMULATION_CYCLIC_CONTROL:
          *UsageText = "Cyclic Control";
          break;
        case HID_USAGE_SIMULATION_CYCLIC_TRIM:
          *UsageText = "Cyclic Trim";
          break;
        case HID_USAGE_SIMULATION_FLIGHT_YOKE:
          *UsageText = "Flight Yoke";
          break;
        case HID_USAGE_SIMULATION_TRACK_CONTROL:
          *UsageText = "Track Control";
          break;
        case HID_USAGE_SIMULATION_AILERON:
          *UsageText = "Aileron";
          break;
        case HID_USAGE_SIMULATION_AILERON_TRIM:
          *UsageText = "Aileron Trim";
          break;
        case HID_USAGE_SIMULATION_ANTITORQUE_CONTROL:
          *UsageText = "Anti-Torque Control";
          break;
        case HID_USAGE_SIMULATION_AUTOPILOT_ENABLE:
          *UsageText = "Enable Autopilot";
          break;
        case HID_USAGE_SIMULATION_CHAFF_RELEASE:
          *UsageText = "Chaff Release";
          break;
        case HID_USAGE_SIMULATION_COLLECTIVE_CONTROL:
          *UsageText = "Collective Control";
          break;
        case HID_USAGE_SIMULATION_DIVE_BREAK:
          *UsageText = "Dive Break";
          break;
        case HID_USAGE_SIMULATION_ELECTRONIC_COUNTERMEASURES:
          *UsageText = "Electronic Countermeasures";
          break;
        case HID_USAGE_SIMULATION_ELEVATOR:
          *UsageText = "Elevator";
          break;
        case HID_USAGE_SIMULATION_ELEVATOR_TRIM:
          *UsageText = "Elevator Trim";
          break;
        case HID_USAGE_SIMULATION_RUDDER:
          *UsageText = "Rudder";
          break;
        case HID_USAGE_SIMULATION_THROTTLE:
          *UsageText = "Throttle";
          break;
        case HID_USAGE_SIMULATION_FLIGHT_COMMUNICATIONS:
          *UsageText = "Flight Communications";
          break;
        case HID_USAGE_SIMULATION_FLARE_RELEASE:
          *UsageText = "Flare Release";
          break;
        case HID_USAGE_SIMULATION_LANDING_GEAR:
          *UsageText = "Landing Gear";
          break;
        case HID_USAGE_SIMULATION_TOE_BRAKE:
          *UsageText = "Toe Brake";
          break;
        case HID_USAGE_SIMULATION_TRIGGER:
          *UsageText = "Trigger";
          break;
        case HID_USAGE_SIMULATION_WEAPONS_ARM:
          *UsageText = "Arm Weapons";
          break;
        case HID_USAGE_SIMULATION_WEAPONS_SELECT:
          *UsageText = "Select Weapons";
          break;
        case HID_USAGE_SIMULATION_WING_FLAPS:
          *UsageText = "Wing Flaps";
          break;
        case HID_USAGE_SIMULATION_ACCELERATOR:
          *UsageText = "Accelerator";
          break;
        case HID_USAGE_SIMULATION_BRAKE:
          *UsageText = "Brake";
          break;
        case HID_USAGE_SIMULATION_CLUTCH:
          *UsageText = "Clutch";
          break;
        case HID_USAGE_SIMULATION_SHIFTER:
          *UsageText = "Shifter";
          break;
        case HID_USAGE_SIMULATION_STEERING:
          *UsageText = "Steering";
          break;
        case HID_USAGE_SIMULATION_TURRET_DIRECTION:
          *UsageText = "Turret Direction";
          break;
        case HID_USAGE_SIMULATION_BARREL_ELEVATION:
          *UsageText = "Barrel Elevation";
          break;
        case HID_USAGE_SIMULATION_DIVE_PLANE:
          *UsageText = "Dive Plane";
          break;
        case HID_USAGE_SIMULATION_BALLAST:
          *UsageText = "Ballast";
          break;
        case HID_USAGE_SIMULATION_BICYCLE_CRANK:
          *UsageText = "Bicycle Crank";
          break;
        case HID_USAGE_SIMULATION_HANDLE_BARS:
          *UsageText = "Handle Bars";
          break;
        case HID_USAGE_SIMULATION_FRONT_BRAKE:
          *UsageText = "Front Brake";
          break;
        case HID_USAGE_SIMULATION_REAR_BRAKE:
          *UsageText = "Rear Brake";
          break;
      }
      break;
    case HID_USAGE_PAGE_VR:
      *UsagePageText = "Virtual Reality";
      switch(Usage)
      {
        case HID_USAGE_VR_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_VR_BELT:
          *UsageText = "Belt";
          break;
        case HID_USAGE_VR_BODY_SUIT:
          *UsageText = "Body Suit";
          break;
        case HID_USAGE_VR_FLEXOR:
          *UsageText = "Flexor";
          break;
        case HID_USAGE_VR_GLOVE:
          *UsageText = "Glove";
          break;
        case HID_USAGE_VR_HEAD_TRACKER:
          *UsageText = "Head Tracker";
          break;
        case HID_USAGE_VR_HEAD_MOUNTED_DISPLAY:
          *UsageText = "Head Mounted Display";
          break;
        case HID_USAGE_VR_HAND_TRACKER:
          *UsageText = "Hand Tracker";
          break;
        case HID_USAGE_VR_OCULOMETER:
          *UsageText = "Oculometer";
          break;
        case HID_USAGE_VR_VEST:
          *UsageText = "Vest";
          break;
        case HID_USAGE_VR_ANIMATRONIC_DEVICE:
          *UsageText = "Animatronic Device";
          break;
        case HID_USAGE_VR_STEREO_ENABLE:
          *UsageText = "Stereo Enable";
          break;
        case HID_USAGE_VR_DISPLAY_ENABLE:
          *UsageText = "Display Enable";
          break;
      }
      break;
    case HID_USAGE_PAGE_SPORT:
      *UsagePageText = "Sport";
      switch(Usage)
      {
        case HID_USAGE_SPORT_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_SPORT_BASEBALL_BAT:
          *UsageText = "Baseball Bat";
          break;
        case HID_USAGE_SPORT_GOLF_CLUB:
          *UsageText = "Golf Club";
          break;
        case HID_USAGE_SPORT_ROWING_MACHINE:
          *UsageText = "Rowing Machine";
          break;
        case HID_USAGE_SPORT_TREADMILL:
          *UsageText = "Treadmill";
          break;
        case HID_USAGE_SPORT_OAR:
          *UsageText = "Oar";
          break;
        case HID_USAGE_SPORT_SLOPE:
          *UsageText = "Slope";
          break;
        case HID_USAGE_SPORT_RATE:
          *UsageText = "Rate";
          break;
        case HID_USAGE_SPORT_STICK_SPEED:
          *UsageText = "Stick Speed";
          break;
        case HID_USAGE_SPORT_STICK_FACE_ANGLE:
          *UsageText = "Stick Face Angle";
          break;
        case HID_USAGE_SPORT_STICK_HEEL_TOE:
          *UsageText = "Stick Heel/Toe";
          break;
        case HID_USAGE_SPORT_STICK_FOLLOW_THROUGH:
          *UsageText = "Stick Follow Through";
          break;
        case HID_USAGE_SPORT_STICK_TEMPO:
          *UsageText = "Stick Tempo";
          break;
        case HID_USAGE_SPORT_STICK_TYPE:
          *UsageText = "Stick Type";
          break;
        case HID_USAGE_SPORT_STICK_HEIGHT:
          *UsageText = "Stick Height";
          break;
        case HID_USAGE_SPORT_PUTTER:
          *UsageText = "Putter";
          break;
        case HID_USAGE_SPORT_IRON_1:
          *UsageText = "Iron 1";
          break;
        case HID_USAGE_SPORT_IRON_2:
          *UsageText = "Iron 2";
          break;
        case HID_USAGE_SPORT_IRON_3:
          *UsageText = "Iron 3";
          break;
        case HID_USAGE_SPORT_IRON_4:
          *UsageText = "Iron 4";
          break;
        case HID_USAGE_SPORT_IRON_5:
          *UsageText = "Iron 5";
          break;
        case HID_USAGE_SPORT_IRON_6:
          *UsageText = "Iron 6";
          break;
        case HID_USAGE_SPORT_IRON_7:
          *UsageText = "Iron 7";
          break;
        case HID_USAGE_SPORT_IRON_8:
          *UsageText = "Iron 8";
          break;
        case HID_USAGE_SPORT_IRON_9:
          *UsageText = "Iron 9";
          break;
        case HID_USAGE_SPORT_IRON_10:
          *UsageText = "Iron 10";
          break;
        case HID_USAGE_SPORT_IRON_11:
          *UsageText = "Iron 11";
          break;
        case HID_USAGE_SPORT_SAND_WEDGE:
          *UsageText = "Sand Wedge";
          break;
        case HID_USAGE_SPORT_LOFT_WEDGE:
          *UsageText = "Loft Wedge";
          break;
        case HID_USAGE_SPORT_POWER_WEDGE:
          *UsageText = "Power Wedge";
          break;
        case HID_USAGE_SPORT_WOOD_1:
          *UsageText = "Wood 1";
          break;
        case HID_USAGE_SPORT_WOOD_3:
          *UsageText = "Wood 3";
          break;
        case HID_USAGE_SPORT_WOOD_5:
          *UsageText = "Wood 5";
          break;
        case HID_USAGE_SPORT_WOOD_7:
          *UsageText = "Wood 7";
          break;
        case HID_USAGE_SPORT_WOOD_9:
          *UsageText = "Wood 9";
          break;
      }
      break;
    case HID_USAGE_PAGE_GAME:
      *UsagePageText = "Game";
      switch(Usage)
      {
        case HID_USAGE_GAME_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_GAME_3D_GAME_CONTROLLER:
          *UsageText = "3D Game Controller";
          break;
        case HID_USAGE_GAME_PINBALL_DEVICE:
          *UsageText = "Pinball Device";
          break;
        case HID_USAGE_GAME_GUN_DEVICE:
          *UsageText = "Gun Device";
          break;
        case HID_USAGE_GAME_POINT_OF_VIEW:
          *UsageText = "Point of View";
          break;
        case HID_USAGE_GAME_TURN_RIGHT_LEFT:
          *UsageText = "Turn Right/Left";
          break;
        case HID_USAGE_GAME_PITCH_FORWARD_BACKWARD:
          *UsageText = "Pitch Forward/Backward";
          break;
        case HID_USAGE_GAME_ROLL_RIGHT_LEFT:
          *UsageText = "Roll Right/Left";
          break;
        case HID_USAGE_GAME_MOVE_RIGHT_LEFT:
          *UsageText = "Move Right/Left";
          break;
        case HID_USAGE_GAME_MOVE_FORWARD_BACKWARD:
          *UsageText = "Move Forward/Backward";
          break;
        case HID_USAGE_GAME_MOVE_UP_DOWN:
          *UsageText = "Move Up/Down";
          break;
        case HID_USAGE_GAME_LEAN_RIGHT_LEFT:
          *UsageText = "Lean Right/Left";
          break;
        case HID_USAGE_GAME_LEAN_FORWARD_BACKWARD:
          *UsageText = "Lean Forward/Backward";
          break;
        case HID_USAGE_GAME_HEIGHT_OF_POV:
          *UsageText = "Height of POV";
          break;
        case HID_USAGE_GAME_FLIPPER:
          *UsageText = "Flipper";
          break;
        case HID_USAGE_GAME_SECONDARY_FLIPPER:
          *UsageText = "Secondary Flipper";
          break;
        case HID_USAGE_GAME_BUMP:
          *UsageText = "Bump";
          break;
        case HID_USAGE_GAME_NEW_GAME:
          *UsageText = "New Game";
          break;
        case HID_USAGE_GAME_SHOOT_BALL:
          *UsageText = "Shoot Ball";
          break;
        case HID_USAGE_GAME_PLAYER:
          *UsageText = "Player";
          break;
        case HID_USAGE_GAME_GUN_BOLT:
          *UsageText = "Gun Bolt";
          break;
        case HID_USAGE_GAME_GUN_CLIP:
          *UsageText = "Gun Clip";
          break;
        case HID_USAGE_GAME_GUN_SELECTOR:
          *UsageText = "Gun Selector";
          break;
        case HID_USAGE_GAME_GUN_SINGLE_SHOT:
          *UsageText = "Gun Single Shot";
          break;
        case HID_USAGE_GAME_GUN_BURST:
          *UsageText = "Gun Burst";
          break;
        case HID_USAGE_GAME_GUN_AUTOMATIC:
          *UsageText = "Gun Automatic";
          break;
        case HID_USAGE_GAME_GUN_SAFETY:
          *UsageText = "Gun Safety";
          break;
        case HID_USAGE_GAME_GAMEPAD_FIRE_JUMP:
          *UsageText = "Gamepad Fire/Jump";
          break;
        case HID_USAGE_GAME_GAMEPAD_TRIGGER:
          *UsageText = "Gamepad Trigger";
          break;
      }
      break;
    case HID_USAGE_PAGE_GENERIC_GAME_CONTROLS:
      *UsagePageText = "Generic";
      switch(Usage)
      {
        case HID_USAGE_GENERIC_GAME_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_GENERIC_GAME_BATTERY_STRENGTH:
          *UsageText = "Battery Strength";
          break;
        case HID_USAGE_GENERIC_GAME_WIRELESS_CHANNEL:
          *UsageText = "Wireless Channel";
          break;
        case HID_USAGE_GENERIC_GAME_WIRELESS_ID:
          *UsageText = "Wireless ID";
          break;
      }
      break;
    case HID_USAGE_PAGE_KEYBOARD:
      
      *UsagePageText = "Keyboard";
      switch(Usage)
      {
        case HID_USAGE_KEYBOARD_NOEVENT:
          *UsageText = "Empty";
          break;
        case HID_USAGE_KEYBOARD_ROLLOVER:
          *UsageText = "Rollover";
          break;
        case HID_USAGE_KEYBOARD_POSTFAIL:
          *UsageText = "Postfail";
          break;
        case HID_USAGE_KEYBOARD_UNDEFINED:
          *UsageText = "Undefined Error";
          break;
        case HID_USAGE_KEYBOARD_aA:
          *UsageText = "A";
          break;
        case HID_USAGE_KEYBOARD_bB:
          *UsageText = "B";
          break;
        case HID_USAGE_KEYBOARD_cC:
          *UsageText = "C";
          break;
        case HID_USAGE_KEYBOARD_dD:
          *UsageText = "D";
          break;
        case HID_USAGE_KEYBOARD_eE:
          *UsageText = "E";
          break;
        case HID_USAGE_KEYBOARD_fF:
          *UsageText = "F";
          break;
        case HID_USAGE_KEYBOARD_gG:
          *UsageText = "G";
          break;
        case HID_USAGE_KEYBOARD_hH:
          *UsageText = "H";
          break;
        case HID_USAGE_KEYBOARD_iI:
          *UsageText = "I";
          break;
        case HID_USAGE_KEYBOARD_jJ:
          *UsageText = "J";
          break;
        case HID_USAGE_KEYBOARD_kK:
          *UsageText = "K";
          break;
        case HID_USAGE_KEYBOARD_lL:
          *UsageText = "L";
          break;
        case HID_USAGE_KEYBOARD_mM:
          *UsageText = "M";
          break;
        case HID_USAGE_KEYBOARD_nN:
          *UsageText = "N";
          break;
        case HID_USAGE_KEYBOARD_oO:
          *UsageText = "O";
          break;
        case HID_USAGE_KEYBOARD_pP:
          *UsageText = "P";
          break;
        case HID_USAGE_KEYBOARD_qQ:
          *UsageText = "Q";
          break;
        case HID_USAGE_KEYBOARD_rR:
          *UsageText = "R";
          break;
        case HID_USAGE_KEYBOARD_sS:
          *UsageText = "S";
          break;
        case HID_USAGE_KEYBOARD_tT:
          *UsageText = "T";
          break;
        case HID_USAGE_KEYBOARD_uU:
          *UsageText = "U";
          break;
        case HID_USAGE_KEYBOARD_vV:
          *UsageText = "V";
          break;
        case HID_USAGE_KEYBOARD_wW:
          *UsageText = "W";
          break;
        case HID_USAGE_KEYBOARD_xX:
          *UsageText = "X";
          break;
        case HID_USAGE_KEYBOARD_yY:
          *UsageText = "Y";
          break;
        case HID_USAGE_KEYBOARD_zZ:
          *UsageText = "Z";
          break;
        case HID_USAGE_KEYBOARD_ONE:
          *UsageText = "1";
          break;
        case HID_USAGE_KEYBOARD_TWO:
          *UsageText = "2";
          break;
        case HID_USAGE_KEYBOARD_THREE:
          *UsageText = "3";
          break;
        case HID_USAGE_KEYBOARD_FOUR:
          *UsageText = "4";
          break;
        case HID_USAGE_KEYBOARD_FIVE:
          *UsageText = "5";
          break;
        case HID_USAGE_KEYBOARD_SIX:
          *UsageText = "6";
          break;
        case HID_USAGE_KEYBOARD_SEVEN:
          *UsageText = "7";
          break;
        case HID_USAGE_KEYBOARD_EIGHT:
          *UsageText = "8";
          break;
        case HID_USAGE_KEYBOARD_NINE:
          *UsageText = "9";
          break;
        case HID_USAGE_KEYBOARD_ZERO:
          *UsageText = "0";
          break;
        case HID_USAGE_KEYBOARD_ENTER:
          *UsageText = "Enter (not Return)";
          break;
        case HID_USAGE_KEYBOARD_ESCAPE:
          *UsageText = "Esc";
          break;
        case HID_USAGE_KEYBOARD_BACKSPACE:
          *UsageText = "Backspace";
          break;
        case HID_USAGE_KEYBOARD_TAB:
          *UsageText = "Tabulator";
          break;
        case HID_USAGE_KEYBOARD_SPACE:
          *UsageText = "Space";
          break;
        case HID_USAGE_KEYBOARD_MINUS:
          *UsageText = "-";
          break;
        case HID_USAGE_KEYBOARD_EQUAL:
          *UsageText = "=";
          break;
        case HID_USAGE_KEYBOARD_LSQBRACKET:
          *UsageText = "[";
          break;
        case HID_USAGE_KEYBOARD_RSQBRACKET:
          *UsageText = "]";
          break;
        case HID_USAGE_KEYBOARD_BACKSLASH:
          *UsageText = "\\";
          break;
        case HID_USAGE_KEYBOARD_HASHMARK2:
          *UsageText = "# 2";
          break;
        case HID_USAGE_KEYBOARD_SEMICOLON:
          *UsageText = ";";
          break;
        case HID_USAGE_KEYBOARD_APOSTROPH:
          *UsageText = """";
          break;
        case HID_USAGE_KEYBOARD_GRAVEACCENT:
          *UsageText = "`";
          break;
        case HID_USAGE_KEYBOARD_COMMA:
          *UsageText = ",";
          break;
        case HID_USAGE_KEYBOARD_DOT:
          *UsageText = ".";
          break;
        case HID_USAGE_KEYBOARD_SLASH:
          *UsageText = "/";
          break;
        case HID_USAGE_KEYBOARD_CAPS_LOCK:
          *UsageText = "Caps Lock";
          break;
        case HID_USAGE_KEYBOARD_F1:
          *UsageText = "F1";
          break;
        case HID_USAGE_KEYBOARD_F2:
          *UsageText = "F2";
          break;
        case HID_USAGE_KEYBOARD_F3:
          *UsageText = "F3";
          break;
        case HID_USAGE_KEYBOARD_F4:
          *UsageText = "F4";
          break;
        case HID_USAGE_KEYBOARD_F5:
          *UsageText = "F5";
          break;
        case HID_USAGE_KEYBOARD_F6:
          *UsageText = "F6";
          break;
        case HID_USAGE_KEYBOARD_F7:
          *UsageText = "F7";
          break;
        case HID_USAGE_KEYBOARD_F8:
          *UsageText = "F8";
          break;
        case HID_USAGE_KEYBOARD_F9:
          *UsageText = "F9";
          break;
        case HID_USAGE_KEYBOARD_F10:
          *UsageText = "F10";
          break;
        case HID_USAGE_KEYBOARD_F11:
          *UsageText = "F11";
          break;
        case HID_USAGE_KEYBOARD_F12:
          *UsageText = "F12";
          break;
        case HID_USAGE_KEYBOARD_PRINT_SCREEN:
          *UsageText = "Print Screen";
          break;
        case HID_USAGE_KEYBOARD_SCROLL_LOCK:
          *UsageText = "Scroll Lock";
          break;
        case HID_USAGE_KEYBOARD_PAUSE:
          *UsageText = "Pause";
          break;
        case HID_USAGE_KEYBOARD_INSERT:
          *UsageText = "Ins";
          break;
        case HID_USAGE_KEYBOARD_HOME:
          *UsageText = "Home";
          break;
        case HID_USAGE_KEYBOARD_PAGEUP:
          *UsageText = "PgUp";
          break;
        case HID_USAGE_KEYBOARD_DELETE:
          *UsageText = "Del";
          break;
        case HID_USAGE_KEYBOARD_END:
          *UsageText = "End";
          break;
        case HID_USAGE_KEYBOARD_PAGEDOWN:
          *UsageText = "PgDn";
          break;
        case HID_USAGE_KEYBOARD_RIGHT:
          *UsageText = "Right Arrow";
          break;
        case HID_USAGE_KEYBOARD_LEFT:
          *UsageText = "Left Arrow";
          break;
        case HID_USAGE_KEYBOARD_DOWN:
          *UsageText = "Down Arrow";
          break;
        case HID_USAGE_KEYBOARD_UP:
          *UsageText = "Up Arrow";
          break;
        case HID_USAGE_KEYPAD_NUM_LOCK:
          *UsageText = "Keypad Num Lock";
          break;
        case HID_USAGE_KEYPAD_SLASH:
          *UsageText = "Keypad /";
          break;
        case HID_USAGE_KEYPAD_STAR:
          *UsageText = "Keypad *";
          break;
        case HID_USAGE_KEYPAD_MINUS:
          *UsageText = "Keypad -";
          break;
        case HID_USAGE_KEYPAD_PLUS:
          *UsageText = "Keypad +";
          break;
        case HID_USAGE_KEYPAD_ENTER:
          *UsageText = "Keypad Enter";
          break;
        case HID_USAGE_KEYPAD_ONE:
          *UsageText = "Keypad 1";
          break;
        case HID_USAGE_KEYPAD_TWO:
          *UsageText = "Keypad 2";
          break;
        case HID_USAGE_KEYPAD_THREE:
          *UsageText = "Keypad 3";
          break;
        case HID_USAGE_KEYPAD_FOUR:
          *UsageText = "Keypad 4";
          break;
        case HID_USAGE_KEYPAD_FIVE:
          *UsageText = "Keypad 5";
          break;
        case HID_USAGE_KEYPAD_SIX:
          *UsageText = "Keypad 6";
          break;
        case HID_USAGE_KEYPAD_SEVEN:
          *UsageText = "Keypad 7";
          break;
        case HID_USAGE_KEYPAD_EIGHT:
          *UsageText = "Keypad 8";
          break;
        case HID_USAGE_KEYPAD_NINE:
          *UsageText = "Keypad 9";
          break;
        case HID_USAGE_KEYPAD_ZERO:
          *UsageText = "Keypad 0";
          break;
        case HID_USAGE_KEYPAD_DOT:
          *UsageText = "Keypad .";
          break;
        case HID_USAGE_KEYBOARD_BACKSLASH2:
          *UsageText = "\\ 2";
          break;
        case HID_USAGE_KEYBOARD_APPLICATION:
          *UsageText = "Application";
          break;
        case HID_USAGE_KEYBOARD_POWER:
          *UsageText = "Power";
          break;
        case HID_USAGE_KEYPAD_EQUAL2:
          *UsageText = "Keypad = 2";
          break;
        case HID_USAGE_KEYBOARD_F13:
          *UsageText = "F13";
          break;
        case HID_USAGE_KEYBOARD_F14:
          *UsageText = "F14";
          break;
        case HID_USAGE_KEYBOARD_F15:
          *UsageText = "F15";
          break;
        case HID_USAGE_KEYBOARD_F16:
          *UsageText = "F16";
          break;
        case HID_USAGE_KEYBOARD_F17:
          *UsageText = "F17";
          break;
        case HID_USAGE_KEYBOARD_F18:
          *UsageText = "F18";
          break;
        case HID_USAGE_KEYBOARD_F19:
          *UsageText = "F19";
          break;
        case HID_USAGE_KEYBOARD_F20:
          *UsageText = "F20";
          break;
        case HID_USAGE_KEYBOARD_F21:
          *UsageText = "F21";
          break;
        case HID_USAGE_KEYBOARD_F22:
          *UsageText = "F22";
          break;
        case HID_USAGE_KEYBOARD_F23:
          *UsageText = "F23";
          break;
        case HID_USAGE_KEYBOARD_F24:
          *UsageText = "F24";
          break;
        case HID_USAGE_KEYBOARD_EXECUTE:
          *UsageText = "Execute";
          break;
        case HID_USAGE_KEYBOARD_HELP:
          *UsageText = "Help";
          break;
        case HID_USAGE_KEYBOARD_MENU:
          *UsageText = "Menu";
          break;
        case HID_USAGE_KEYBOARD_SELECT:
          *UsageText = "Select";
          break;
        case HID_USAGE_KEYBOARD_STOP:
          *UsageText = "Stop";
          break;
        case HID_USAGE_KEYBOARD_AGAIN:
          *UsageText = "Again";
          break;
        case HID_USAGE_KEYBOARD_UNDO:
          *UsageText = "Undo";
          break;
        case HID_USAGE_KEYBOARD_CUT:
          *UsageText = "Cut";
          break;
        case HID_USAGE_KEYBOARD_COPY:
          *UsageText = "Copy";
          break;
        case HID_USAGE_KEYBOARD_PASTE:
          *UsageText = "Paste";
          break;
        case HID_USAGE_KEYBOARD_FIND:
          *UsageText = "Find";
          break;
        case HID_USAGE_KEYBOARD_MUTE:
          *UsageText = "Mute";
          break;
        case HID_USAGE_KEYBOARD_VOLUME_UP:
          *UsageText = "Volume Up";
          break;
        case HID_USAGE_KEYBOARD_VOLUME_DOWN:
          *UsageText = "Volume Down";
          break;
        case HID_USAGE_KEYBOARD_LOCKCAPS:
          *UsageText = "Caps Lock";
          break;
        case HID_USAGE_KEYBOARD_LOCKNUM:
          *UsageText = "Num Lock";
          break;
        case HID_USAGE_KEYBOARD_LOCKSCROLL:
          *UsageText = "Scroll Lock";
          break;
        case HID_USAGE_KEYPAD_COMMA:
          *UsageText = "Keypad ,";
          break;
        case HID_USAGE_KEYPAD_EQUALSIGN:
          *UsageText = "Keypad =";
          break;
        case HID_USAGE_KEYBOARD_INATL1:
          *UsageText = "International 1";
          break;
        case HID_USAGE_KEYBOARD_INATL2:
          *UsageText = "International 2";
          break;
        case HID_USAGE_KEYBOARD_INATL3:
          *UsageText = "International 3";
          break;
        case HID_USAGE_KEYBOARD_INATL4:
          *UsageText = "International 4";
          break;
        case HID_USAGE_KEYBOARD_INATL5:
          *UsageText = "International 5";
          break;
        case HID_USAGE_KEYBOARD_INATL6:
          *UsageText = "International 6";
          break;
        case HID_USAGE_KEYBOARD_INATL7:
          *UsageText = "International 7";
          break;
        case HID_USAGE_KEYBOARD_INATL8:
          *UsageText = "International 8";
          break;
        case HID_USAGE_KEYBOARD_INATL9:
          *UsageText = "International 9";
          break;
        case HID_USAGE_KEYBOARD_LANG1:
          *UsageText = "Language 1";
          break;
        case HID_USAGE_KEYBOARD_LANG2:
          *UsageText = "Language 2";
          break;
        case HID_USAGE_KEYBOARD_LANG3:
          *UsageText = "Language 3";
          break;
        case HID_USAGE_KEYBOARD_LANG4:
          *UsageText = "Language 4";
          break;
        case HID_USAGE_KEYBOARD_LANG5:
          *UsageText = "Language 5";
          break;
        case HID_USAGE_KEYBOARD_LANG6:
          *UsageText = "Language 6";
          break;
        case HID_USAGE_KEYBOARD_LANG7:
          *UsageText = "Language 7";
          break;
        case HID_USAGE_KEYBOARD_LANG8:
          *UsageText = "Language 8";
          break;
        case HID_USAGE_KEYBOARD_LANG9:
          *UsageText = "Language 9";
          break;
        case HID_USAGE_KEYBOARD_ALTERASE:
          *UsageText = "Alternate Erase";
          break;
        case HID_USAGE_KEYBOARD_SYSREQ:
          *UsageText = "Sys Request";
          break;
        case HID_USAGE_KEYBOARD_CANCEL:
          *UsageText = "Cancel";
          break;
        case HID_USAGE_KEYBOARD_CLEAR:
          *UsageText = "Clear";
          break;
        case HID_USAGE_KEYBOARD_PRIOR:
          *UsageText = "Prior";
          break;
        case HID_USAGE_KEYBOARD_RETURN:
          *UsageText = "Return (not Enter)";
          break;
        case HID_USAGE_KEYBOARD_SEPARATOR:
          *UsageText = "Separator";
          break;
        case HID_USAGE_KEYBOARD_OUT:
          *UsageText = "Out";
          break;
        case HID_USAGE_KEYBOARD_OPER:
          *UsageText = "Oper";
          break;
        case HID_USAGE_KEYBOARD_CLEAR_AGAIN:
          *UsageText = "Clear/Again";
          break;
        case HID_USAGE_KEYBOARD_CRSEL:
          *UsageText = "CrSel/Props";
          break;
        case HID_USAGE_KEYBOARD_EXSEL:
          *UsageText = "ExSel";
          break;
        case HID_USAGE_KEYPAD_HUNDREDS:
          *UsageText = "Keypad 00";
          break;
        case HID_USAGE_KEYPAD_THOUSANDS:
          *UsageText = "Keypad 000";
          break;
        case HID_USAGE_KEYPAD_THOUSANDS_SEP:
          *UsageText = "Keypad Thousands Separator";
          break;
        case HID_USAGE_KEYPAD_DECIMAL_SEP:
          *UsageText = "Keypad Decimal Separator";
          break;
        case HID_USAGE_KEYPAD_CURR_UNIT:
          *UsageText = "Keypad Currency Unit";
          break;
        case HID_USAGE_KEYPAD_CURR_SUBUNIT:
          *UsageText = "Keypad Currency Subunit";
          break;
        case HID_USAGE_KEYPAD_LROUNDBRACKET:
          *UsageText = "Keypad (";
          break;
        case HID_USAGE_KEYPAD_RROUNDBRACKET:
          *UsageText = "Keypad )";
          break;
        case HID_USAGE_KEYPAD_LCURLYBRACKET:
          *UsageText = "Keypad {";
          break;
        case HID_USAGE_KEYPAD_RCURLYBRACKET:
          *UsageText = "Keypad }";
          break;
        case HID_USAGE_KEYPAD_TABULATOR:
          *UsageText = "Keypad Tabulator";
          break;
        case HID_USAGE_KEYPAD_BACKSPACE:
          *UsageText = "Keypad Backspace";
          break;
        case HID_USAGE_KEYPAD_A:
          *UsageText = "Keypad A";
          break;
        case HID_USAGE_KEYPAD_B:
          *UsageText = "Keypad B";
          break;
        case HID_USAGE_KEYPAD_C:
          *UsageText = "Keypad C";
          break;
        case HID_USAGE_KEYPAD_D:
          *UsageText = "Keypad D";
          break;
        case HID_USAGE_KEYPAD_E:
          *UsageText = "Keypad E";
          break;
        case HID_USAGE_KEYPAD_F:
          *UsageText = "Keypad F";
          break;
        case HID_USAGE_KEYPAD_XOR:
          *UsageText = "Keypad XOR";
          break;
        case HID_USAGE_KEYPAD_CIRCUMFLEX:
          *UsageText = "Keypad ^";
          break;
        case HID_USAGE_KEYPAD_PERCENT:
          *UsageText = "Keypad %";
          break;
        case HID_USAGE_KEYPAD_BIGGER_THAN:
          *UsageText = "Keypad <";
          break;
        case HID_USAGE_KEYPAD_LESS_THAN:
          *UsageText = "Keypad >";
          break;
        case HID_USAGE_KEYPAD_BINARY_AND:
          *UsageText = "Keypad &";
          break;
        case HID_USAGE_KEYPAD_LOGICAL_AND:
          *UsageText = "Keypad &&";
          break;
        case HID_USAGE_KEYPAD_BINARY_OR:
          *UsageText = "Keypad |";
          break;
        case HID_USAGE_KEYPAD_LOGICAL_OR:
          *UsageText = "Keypad ||";
          break;
        case HID_USAGE_KEYPAD_COLON:
          *UsageText = "Keypad :";
          break;
        case HID_USAGE_KEYPAD_HASHMARK:
          *UsageText = "Keypad #";
          break;
        case HID_USAGE_KEYPAD_SPACE:
          *UsageText = "Keypad Space";
          break;
        case HID_USAGE_KEYPAD_AT:
          *UsageText = "Keypad @";
          break;
        case HID_USAGE_KEYPAD_EXCLAMATION:
          *UsageText = "Keypad !";
          break;
        case HID_USAGE_KEYPAD_MEM_STORE:
          *UsageText = "Keypad Memory Store";
          break;
        case HID_USAGE_KEYPAD_MEM_RECALL:
          *UsageText = "Keypad Memory Recall";
          break;
        case HID_USAGE_KEYPAD_MEM_CLEAR:
          *UsageText = "Keypad Memory Clear";
          break;
        case HID_USAGE_KEYPAD_MEM_ADD:
          *UsageText = "Keypad Memory Add";
          break;
        case HID_USAGE_KEYPAD_MEM_SUBTRACT:
          *UsageText = "Keypad Memory Subtract";
          break;
        case HID_USAGE_KEYPAD_MEM_MULTIPLY:
          *UsageText = "Keypad Memory Multiply";
          break;
        case HID_USAGE_KEYPAD_MEM_DIVIDE:
          *UsageText = "Keypad Memory Divide";
          break;
        case HID_USAGE_KEYPAD_PLUS_MINUS:
          *UsageText = "Keypad Memory Minus";
          break;
        case HID_USAGE_KEYPAD_CLEAR:
          *UsageText = "Keypad Clear";
          break;
        case HID_USAGE_KEYPAD_CLEAR_ENTRY:
          *UsageText = "Keypad Clear Entry";
          break;
        case HID_USAGE_KEYPAD_BINARY:
          *UsageText = "Keypad Binary";
          break;
        case HID_USAGE_KEYPAD_OCTAL:
          *UsageText = "Keypad Octal";
          break;
        case HID_USAGE_KEYPAD_DECIMAL:
          *UsageText = "Keypad Decimal";
          break;
        case HID_USAGE_KEYPAD_HEXADECIMAL:
          *UsageText = "Keypad Hexadecimal";
          break;
        case HID_USAGE_KEYPAD_RESERVED1:
          *UsageText = "Keypad Reserved1";
          break;
        case HID_USAGE_KEYPAD_RESERVED2:
          *UsageText = "Keypad Reserved2";
          break;
        case HID_USAGE_KEYBOARD_LCTRL:
          *UsageText = "Left Ctrl";
          break;
        case HID_USAGE_KEYBOARD_LSHFT:
          *UsageText = "Left Shift";
          break;
        case HID_USAGE_KEYBOARD_LALT:
          *UsageText = "Left Alt";
          break;
        case HID_USAGE_KEYBOARD_LGUI:
          *UsageText = "Left GUI";
          break;
        case HID_USAGE_KEYBOARD_RCTRL:
          *UsageText = "Right Ctrl";
          break;
        case HID_USAGE_KEYBOARD_RSHFT:
          *UsageText = "Right Shift";
          break;
        case HID_USAGE_KEYBOARD_RALT:
          *UsageText = "Right Alt";
          break;
        case HID_USAGE_KEYBOARD_RGUI:
          *UsageText = "Right GUI";
          break;
      }
      break;
    case HID_USAGE_PAGE_LED:
      *UsagePageText = "LED";
      switch(Usage)
      {
        case HID_USAGE_LED_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_LED_NUM_LOCK:
          *UsageText = "Keyboard Num Lock";
          break;
        case HID_USAGE_LED_CAPS_LOCK:
          *UsageText = "Keyboard Caps Lock";
          break;
        case HID_USAGE_LED_SCROLL_LOCK:
          *UsageText = "Keyboard Scroll Lock";
          break;
        case HID_USAGE_LED_COMPOSE:
          *UsageText = "Keyboard Compose";
          break;
        case HID_USAGE_LED_KANA:
          *UsageText = "Keyboard Kana";
          break;
        case HID_USAGE_LED_POWER:
          *UsageText = "Keyboard Power";
          break;
        case HID_USAGE_LED_SHIFT:
          *UsageText = "Keyboard Shift";
          break;
        case HID_USAGE_LED_DO_NOT_DISTURB:
          *UsageText = "Telephony Do Not Disturb";
          break;
        case HID_USAGE_LED_MUTE:
          *UsageText = "Consumer Indicator Mute";
          break;
        case HID_USAGE_LED_TONE_ENABLE:
          *UsageText = "Consumer Indicator Tone Enable";
          break;
        case HID_USAGE_LED_HIGH_CUT_FILTER:
          *UsageText = "Consumer Indicator High Cut Filter";
          break;
        case HID_USAGE_LED_LOW_CUT_FILTER:
          *UsageText = "Consumer Indicator Low Cut Filter";
          break;
        case HID_USAGE_LED_EQUALIZER_ENABLE:
          *UsageText = "Consumer Indicator Equalizer Enable";
          break;
        case HID_USAGE_LED_SOUND_FIELD_ON:
          *UsageText = "Consumer Indicator Sound Field On";
          break;
        case HID_USAGE_LED_SURROUND_FIELD_ON:
          *UsageText = "Consumer Indicator Surround Field On";
          break;
        case HID_USAGE_LED_REPEAT:
          *UsageText = "Consumer Indicator Repeat";
          break;
        case HID_USAGE_LED_STEREO:
          *UsageText = "Consumer Indicator Stereo";
          break;
        case HID_USAGE_LED_SAMPLING_RATE_DETECT:
          *UsageText = "Consumer Indicator Sampling Rate Detect";
          break;
        case HID_USAGE_LED_SPINNING:
          *UsageText = "Media Transport Indicator Spinning";
          break;
        case HID_USAGE_LED_CAV:
          *UsageText = "Consumer Indicator CAV";
          break;
        case HID_USAGE_LED_CLV:
          *UsageText = "Consumer Indicator CLV";
          break;
        case HID_USAGE_LED_RECORDING_FORMAT_DET:
          *UsageText = "Media Transport Indicator Recording Format Detect";
          break;
        case HID_USAGE_LED_OFF_HOOK:
          *UsageText = "Telephony Off Hook";
          break;
        case HID_USAGE_LED_RING:
          *UsageText = "Telephony Ring";
          break;
        case HID_USAGE_LED_MESSAGE_WAITING:
          *UsageText = "Telephony Message Waiting";
          break;
        case HID_USAGE_LED_DATA_MODE:
          *UsageText = "Telephony Data Mode";
          break;
        case HID_USAGE_LED_BATTERY_OPERATION:
          *UsageText = "Battery Operation";
          break;
        case HID_USAGE_LED_BATTERY_OK:
          *UsageText = "Battery Ok";
          break;
        case HID_USAGE_LED_BATTERY_LOW:
          *UsageText = "Battery Low";
          break;
        case HID_USAGE_LED_SPEAKER:
          *UsageText = "Telephony Speaker";
          break;
        case HID_USAGE_LED_HEAD_SET:
          *UsageText = "Telephony Head Set";
          break;
        case HID_USAGE_LED_HOLD:
          *UsageText = "Telephony Hold";
          break;
        case HID_USAGE_LED_MICROPHONE:
          *UsageText = "Telephony Microphone";
          break;
        case HID_USAGE_LED_COVERAGE:
          *UsageText = "Telephony Coverage";
          break;
        case HID_USAGE_LED_NIGHT_MODE:
          *UsageText = "Telephony Night Mode";
          break;
        case HID_USAGE_LED_SEND_CALLS:
          *UsageText = "Telephony Send Calls";
          break;
        case HID_USAGE_LED_CALL_PICKUP:
          *UsageText = "Telephony Call Pickup";
          break;
        case HID_USAGE_LED_CONFERENCE:
          *UsageText = "Telephony Conference";
          break;
        case HID_USAGE_LED_STAND_BY:
          *UsageText = "Stand-by";
          break;
        case HID_USAGE_LED_CAMERA_ON:
          *UsageText = "Consumer Indicator Camera On";
          break;
        case HID_USAGE_LED_CAMERA_OFF:
          *UsageText = "Consumer Indicator Camera Off";
          break;
        case HID_USAGE_LED_ON_LINE:
          *UsageText = "On Line";
          break;
        case HID_USAGE_LED_OFF_LINE:
          *UsageText = "Off Line";
          break;
        case HID_USAGE_LED_BUSY:
          *UsageText = "Busy";
          break;
        case HID_USAGE_LED_READY:
          *UsageText = "Ready";
          break;
        case HID_USAGE_LED_PAPER_OUT:
          *UsageText = "Printer Indicator Paper Out";
          break;
        case HID_USAGE_LED_PAPER_JAM:
          *UsageText = "Printer Indicator Paper Jam";
          break;
        case HID_USAGE_LED_REMOTE:
          *UsageText = "Remote";
          break;
        case HID_USAGE_LED_FORWARD:
          *UsageText = "Media Transport Forward";
          break;
        case HID_USAGE_LED_REVERSE:
          *UsageText = "Media Transport Reverse";
          break;
        case HID_USAGE_LED_STOP:
          *UsageText = "Media Transport Stop";
          break;
        case HID_USAGE_LED_REWIND:
          *UsageText = "Media Transport Rewind";
          break;
        case HID_USAGE_LED_FAST_FORWARD:
          *UsageText = "Media Transport Fast Forward";
          break;
        case HID_USAGE_LED_PLAY:
          *UsageText = "Media Transport Play";
          break;
        case HID_USAGE_LED_PAUSE:
          *UsageText = "Media Transport Pause";
          break;
        case HID_USAGE_LED_RECORD:
          *UsageText = "Media Transport Record";
          break;
        case HID_USAGE_LED_ERROR:
          *UsageText = "Error";
          break;
        case HID_USAGE_LED_SELECTED_INDICATOR:
          *UsageText = "Selected Indicator";
          break;
        case HID_USAGE_LED_IN_USE_INDICATOR:
          *UsageText = "In Use Indicator";
          break;
        case HID_USAGE_LED_MULTI_MODE_INDICATOR:
          *UsageText = "Multi Mode Indicator";
          break;
        case HID_USAGE_LED_INDICATOR_ON:
          *UsageText = "Indicator On";
          break;
        case HID_USAGE_LED_INDICATOR_FLASH:
          *UsageText = "Indicator Flash";
          break;
        case HID_USAGE_LED_INDICATOR_SLOW_BLINK:
          *UsageText = "Indicator Slow Blink";
          break;
        case HID_USAGE_LED_INDICATOR_FAST_BLINK:
          *UsageText = "Indicator Fast Blink";
          break;
        case HID_USAGE_LED_INDICATOR_OFF:
          *UsageText = "Indicator Off";
          break;
        case HID_USAGE_LED_FLASH_ON_TIME:
          *UsageText = "Flash On-Time";
          break;
        case HID_USAGE_LED_SLOW_BLINK_ON_TIME:
          *UsageText = "Slow Blink On-Time";
          break;
        case HID_USAGE_LED_SLOW_BLINK_OFF_TIME:
          *UsageText = "Slow Blink Off-Time";
          break;
        case HID_USAGE_LED_FAST_BLINK_ON_TIME:
          *UsageText = "Fast Blink On-Time";
          break;
        case HID_USAGE_LED_FAST_BLINK_OFF_TIME:
          *UsageText = "Fast Blink Off-Time";
          break;
        case HID_USAGE_LED_INDICATOR_COLOR:
          *UsageText = "Indicator Color";
          break;
        case HID_USAGE_LED_RED:
          *UsageText = "Red";
          break;
        case HID_USAGE_LED_GREEN:
          *UsageText = "Green";
          break;
        case HID_USAGE_LED_AMBER:
          *UsageText = "Amber";
          break;
        case HID_USAGE_LED_GENERIC_INDICATOR:
          *UsageText = "Generic Indicator";
          break;
        case HID_USAGE_LED_SYSTEM_SUSPEND:
          *UsageText = "System Suspend";
          break;
        case HID_USAGE_LED_EXTERNAL_POWER:
          *UsageText = "External Power Connected";
          break;
      }
      break;
    case HID_USAGE_PAGE_BUTTON:
      *UsagePageText = "Button";
      switch(Usage)
      {
        case HID_USAGE_BUTTON_NO_BUTTON:
          *UsageText = "No Button Pressed";
          break;
          // Usage 1..65535 is the button number
      }
      break;
    case HID_USAGE_PAGE_ORDINAL:
      *UsagePageText = "Ordinal";
      switch(Usage)
      {
        case HID_USAGE_ORDINAL_RESERVED:
          *UsageText = "Reserved";
          break;
          // Usage 1..65535 is the ordinal number
      }
      break;
    case HID_USAGE_PAGE_TELEPHONY:
      *UsagePageText = "Telephony";
      switch(Usage)
      {
        case HID_USAGE_TELEPHONY_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_TELEPHONY_PHONE:
          *UsageText = "Phone";
          break;
        case HID_USAGE_TELEPHONY_ANSWERING_MACHINE:
          *UsageText = "Answering Machine";
          break;
        case HID_USAGE_TELEPHONY_MESSAGE_CONTROLS:
          *UsageText = "Message Controls";
          break;
        case HID_USAGE_TELEPHONY_HANDSET:
          *UsageText = "Handset";
          break;
        case HID_USAGE_TELEPHONY_HEADSET:
          *UsageText = "Headset";
          break;
        case HID_USAGE_TELEPHONY_KEYPAD:
          *UsageText = "Keypad";
          break;
        case HID_USAGE_TELEPHONY_PROGRAMMABLE_BUTTON:
          *UsageText = "Programmable Button";
          break;
        case HID_USAGE_TELEPHONY_HOOK_SWITCH:
          *UsageText = "Hook Switch";
          break;
        case HID_USAGE_TELEPHONY_FLASH:
          *UsageText = "Flash";
          break;
        case HID_USAGE_TELEPHONY_FEATURE:
          *UsageText = "Feature";
          break;
        case HID_USAGE_TELEPHONY_HOLD:
          *UsageText = "Hold";
          break;
        case HID_USAGE_TELEPHONY_REDIAL:
          *UsageText = "Redial";
          break;
        case HID_USAGE_TELEPHONY_TRANSFER:
          *UsageText = "Transfer";
          break;
        case HID_USAGE_TELEPHONY_DROP:
          *UsageText = "Drop";
          break;
        case HID_USAGE_TELEPHONY_PARK:
          *UsageText = "Park";
          break;
        case HID_USAGE_TELEPHONY_FORWARD_CALLS:
          *UsageText = "Forward Calls";
          break;
        case HID_USAGE_TELEPHONY_ALTERNATE_FUNCTION:
          *UsageText = "Alternate Function";
          break;
        case HID_USAGE_TELEPHONY_LINE:
          *UsageText = "Line";
          break;
        case HID_USAGE_TELEPHONY_SPEAKER_PHONE:
          *UsageText = "Speaker Phone";
          break;
        case HID_USAGE_TELEPHONY_CONFERENCE:
          *UsageText = "Conference";
          break;
        case HID_USAGE_TELEPHONY_RING_ENABLE:
          *UsageText = "Ring Enable";
          break;
        case HID_USAGE_TELEPHONY_RING_SELECT:
          *UsageText = "Ring Select";
          break;
        case HID_USAGE_TELEPHONY_PHONE_MUTE:
          *UsageText = "Phone Mute";
          break;
        case HID_USAGE_TELEPHONY_CALLER_ID:
          *UsageText = "Caller ID";
          break;
        case HID_USAGE_TELEPHONY_SEND:
          *UsageText = "Send";
          break;
        case HID_USAGE_TELEPHONY_SPEED_DIAL:
          *UsageText = "Speed Dial";
          break;
        case HID_USAGE_TELEPHONY_STORE_NUMBER:
          *UsageText = "Store Number";
          break;
        case HID_USAGE_TELEPHONY_RECALL_NUMBER:
          *UsageText = "Recall Number";
          break;
        case HID_USAGE_TELEPHONY_PHONE_DIRECTORY:
          *UsageText = "Phone Directory";
          break;
        case HID_USAGE_TELEPHONY_VOICE_MAIL:
          *UsageText = "Voice Mail";
          break;
        case HID_USAGE_TELEPHONY_SCREEN_CALLS:
          *UsageText = "Screen Calls";
          break;
        case HID_USAGE_TELEPHONY_DO_NOT_DISTURB:
          *UsageText = "Do Not Disturb";
          break;
        case HID_USAGE_TELEPHONY_MESSAGE:
          *UsageText = "Message";
          break;
        case HID_USAGE_TELEPHONY_ANSWER_ON_OFF:
          *UsageText = "Answer On/Off";
          break;
        case HID_USAGE_TELEPHONY_INSIDE_DIAL_TONE:
          *UsageText = "Inside Dial Tone";
          break;
        case HID_USAGE_TELEPHONY_OUTSIDE_DIAL_TONE:
          *UsageText = "Outside Dial Tone";
          break;
        case HID_USAGE_TELEPHONY_INSIDE_RING_TONE:
          *UsageText = "Inside Ring Tone";
          break;
        case HID_USAGE_TELEPHONY_OUTSIDE_RING_TONE:
          *UsageText = "Outside Ring Tone";
          break;
        case HID_USAGE_TELEPHONY_PRIORITY_RING_TONE:
          *UsageText = "Priority Ring Tone";
          break;
        case HID_USAGE_TELEPHONY_INSIDE_RINGBACK:
          *UsageText = "Inside Ringback";
          break;
        case HID_USAGE_TELEPHONY_PRIORITY_RINGBACK:
          *UsageText = "Priority Ringback";
          break;
        case HID_USAGE_TELEPHONY_LINE_BUSY_TONE:
          *UsageText = "Line Busy Tone";
          break;
        case HID_USAGE_TELEPHONY_REORDER_TONE:
          *UsageText = "Reorder Tone";
          break;
        case HID_USAGE_TELEPHONY_CALL_WAITING_TONE:
          *UsageText = "Call Waiting Tone";
          break;
        case HID_USAGE_TELEPHONY_CONFIRMATION_TONE_1:
          *UsageText = "Confirmation Tone 1";
          break;
        case HID_USAGE_TELEPHONY_CONFIRMATION_TONE_2:
          *UsageText = "Confirmation Tone 2";
          break;
        case HID_USAGE_TELEPHONY_TONES_OFF:
          *UsageText = "Tones Off";
          break;
        case HID_USAGE_TELEPHONY_OUTSIDE_RINGBACK:
          *UsageText = "Outside Ringback";
          break;
        case HID_USAGE_TELEPHONY_RINGER:
          *UsageText = "Ringer";
          break;
        case HID_USAGE_TELEPHONY_KEY_0:
          *UsageText = "Key 0";
          break;
        case HID_USAGE_TELEPHONY_KEY_1:
          *UsageText = "Key 1";
          break;
        case HID_USAGE_TELEPHONY_KEY_2:
          *UsageText = "Key 2";
          break;
        case HID_USAGE_TELEPHONY_KEY_3:
          *UsageText = "Key 3";
          break;
        case HID_USAGE_TELEPHONY_KEY_4:
          *UsageText = "Key 4";
          break;
        case HID_USAGE_TELEPHONY_KEY_5:
          *UsageText = "Key 5";
          break;
        case HID_USAGE_TELEPHONY_KEY_6:
          *UsageText = "Key 6";
          break;
        case HID_USAGE_TELEPHONY_KEY_7:
          *UsageText = "Key 7";
          break;
        case HID_USAGE_TELEPHONY_KEY_8:
          *UsageText = "Key 8";
          break;
        case HID_USAGE_TELEPHONY_KEY_9:
          *UsageText = "Key 9";
          break;
        case HID_USAGE_TELEPHONY_KEY_STAR:
          *UsageText = "Key *";
          break;
        case HID_USAGE_TELEPHONY_KEY_POUND:
          *UsageText = "Key #";
          break;
        case HID_USAGE_TELEPHONY_KEY_A:
          *UsageText = "Key A";
          break;
        case HID_USAGE_TELEPHONY_KEY_B:
          *UsageText = "Key B";
          break;
        case HID_USAGE_TELEPHONY_KEY_C:
          *UsageText = "Key C";
          break;
        case HID_USAGE_TELEPHONY_KEY_D:
          *UsageText = "Key D";
          break;
      }
      break;
    case HID_USAGE_PAGE_CONSUMER:
      *UsagePageText = "Consumer";
      switch(Usage)
      {
        case HID_USAGE_CONSUMER_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_CONSUMER_CONSUMER_CONTROL:
          *UsageText = "Consumer Control";
          break;
        case HID_USAGE_CONSUMER_NUMERIC_KEY_PAD:
          *UsageText = "Numeric Keypad";
          break;
        case HID_USAGE_CONSUMER_PROGRAMMABLE_BUTTONS:
          *UsageText = "Programmable Buttons";
          break;
        case HID_USAGE_CONSUMER_MICROPHONE:
          *UsageText = "Microphone";
          break;
        case HID_USAGE_CONSUMER_HEADPHONE:
          *UsageText = "Headphone";
          break;
        case HID_USAGE_CONSUMER_GRAPHIC_EQUALIZER:
          *UsageText = "Graphic Equalizer";
          break;
        case HID_USAGE_CONSUMER_PLUS_10:
          *UsageText = "+10";
          break;
        case HID_USAGE_CONSUMER_PLUS_100:
          *UsageText = "+100";
          break;
        case HID_USAGE_CONSUMER_AM_PM:
          *UsageText = "AM/PM";
          break;
        case HID_USAGE_CONSUMER_POWER:
          *UsageText = "Power";
          break;
        case HID_USAGE_CONSUMER_RESET:
          *UsageText = "Reset";
          break;
        case HID_USAGE_CONSUMER_SLEEP:
          *UsageText = "Sleep";
          break;
        case HID_USAGE_CONSUMER_SLEEP_AFTER:
          *UsageText = "Sleep After";
          break;
        case HID_USAGE_CONSUMER_SLEEP_MODE:
          *UsageText = "Sleep Mode";
          break;
        case HID_USAGE_CONSUMER_ILLUMINATION:
          *UsageText = "Illumination";
          break;
        case HID_USAGE_CONSUMER_FUNCTION_BUTTONS:
          *UsageText = "Function Buttons";
          break;
        case HID_USAGE_CONSUMER_MENU:
          *UsageText = "Menu";
          break;
        case HID_USAGE_CONSUMER_MENU_PICK:
          *UsageText = "Menu Pick";
          break;
        case HID_USAGE_CONSUMER_MENU_UP:
          *UsageText = "Menu Up";
          break;
        case HID_USAGE_CONSUMER_MENU_DOWN:
          *UsageText = "Menu Down";
          break;
        case HID_USAGE_CONSUMER_MENU_LEFT:
          *UsageText = "Menu Left";
          break;
        case HID_USAGE_CONSUMER_MENU_RIGHT:
          *UsageText = "Menu Right";
          break;
        case HID_USAGE_CONSUMER_MENU_ESCAPE:
          *UsageText = "Menu Escape";
          break;
        case HID_USAGE_CONSUMER_MENU_VALUE_INCREASE:
          *UsageText = "Menu Value Increase";
          break;
        case HID_USAGE_CONSUMER_MENU_VALUE_DECREASE:
          *UsageText = "Menu Value Decrease";
          break;
        case HID_USAGE_CONSUMER_DATA_ON_SCREEN:
          *UsageText = "Data On Screen";
          break;
        case HID_USAGE_CONSUMER_CLOSED_CAPTION:
          *UsageText = "Closed Caption";
          break;
        case HID_USAGE_CONSUMER_CLOSED_CAPTION_SELECT:
          *UsageText = "Closed Caption Select";
          break;
        case HID_USAGE_CONSUMER_VCR_TV:
          *UsageText = "VCR/TV";
          break;
        case HID_USAGE_CONSUMER_BROADCAST_MODE:
          *UsageText = "Broadcast Mode";
          break;
        case HID_USAGE_CONSUMER_SNAPSHOT:
          *UsageText = "Snapshot";
          break;
        case HID_USAGE_CONSUMER_STILL:
          *UsageText = "Still";
          break;
        case HID_USAGE_CONSUMER_SELECTION:
          *UsageText = "Selection";
          break;
        case HID_USAGE_CONSUMER_ASSIGN_SELECTION:
          *UsageText = "Assign Selection";
          break;
        case HID_USAGE_CONSUMER_MODE_STEP:
          *UsageText = "Mode Step";
          break;
        case HID_USAGE_CONSUMER_RECALL_LAST:
          *UsageText = "Recall Last";
          break;
        case HID_USAGE_CONSUMER_ENTER_CHANNEL:
          *UsageText = "Enter Channel";
          break;
        case HID_USAGE_CONSUMER_ORDER_MOVIE:
          *UsageText = "Order Movie";
          break;
        case HID_USAGE_CONSUMER_CHANNEL:
          *UsageText = "Channel";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECTION:
          *UsageText = "Media Selection";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_COMPUTER:
          *UsageText = "Media Select Computer";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_TV:
          *UsageText = "Media Select TV";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_WWW:
          *UsageText = "Media Select WWW";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_DVD:
          *UsageText = "Media Select DVD";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_TELEPHONE:
          *UsageText = "Media Select Telephone";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_PROGRAM_GUIDE:
          *UsageText = "Media Select Program Guide";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_VIDEO_PHONE:
          *UsageText = "Media Select Video Phone";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_GAMES:
          *UsageText = "Media Select Games";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_MESSAGES:
          *UsageText = "Media Select Messages";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_CD:
          *UsageText = "Media Select CD";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_VCR:
          *UsageText = "Media Select VCR";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_TUNER:
          *UsageText = "Media Select Tuner";
          break;
        case HID_USAGE_CONSUMER_QUIT:
          *UsageText = "Quit";
          break;
        case HID_USAGE_CONSUMER_HELP:
          *UsageText = "Help";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_TAPE:
          *UsageText = "Media Select Tape";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_CABLE:
          *UsageText = "Media Select Cable";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_SATELLITE:
          *UsageText = "Media Select Satellite";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_SECURITY:
          *UsageText = "Media Select Security";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_HOME:
          *UsageText = "Media Select Home";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_CALL:
          *UsageText = "Media Select Call";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_INCREMENT:
          *UsageText = "Channel Increment";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_DECREMENT:
          *UsageText = "Channel Decrement";
          break;
        case HID_USAGE_CONSUMER_MEDIA_SELECT_SAP:
          *UsageText = "Media Select SAP";
          break;
        case HID_USAGE_CONSUMER_RESERVED:
          *UsageText = "Reserved";
          break;
        case HID_USAGE_CONSUMER_VCR_PLUS:
          *UsageText = "VCR Plus";
          break;
        case HID_USAGE_CONSUMER_ONCE:
          *UsageText = "Once";
          break;
        case HID_USAGE_CONSUMER_DAILY:
          *UsageText = "Daily";
          break;
        case HID_USAGE_CONSUMER_WEEKLY:
          *UsageText = "Weekly";
          break;
        case HID_USAGE_CONSUMER_MONTHLY:
          *UsageText = "Monthly";
          break;
        case HID_USAGE_CONSUMER_PLAY:
          *UsageText = "Play";
          break;
        case HID_USAGE_CONSUMER_PAUSE:
          *UsageText = "Pause";
          break;
        case HID_USAGE_CONSUMER_RECORD:
          *UsageText = "Record";
          break;
        case HID_USAGE_CONSUMER_FAST_FORWARD:
          *UsageText = "Fast Forward";
          break;
        case HID_USAGE_CONSUMER_REWIND:
          *UsageText = "Rewind";
          break;
        case HID_USAGE_CONSUMER_SCAN_NEXT_TRACK:
          *UsageText = "Scan Next Track";
          break;
        case HID_USAGE_CONSUMER_SCAN_PREV_TRACK:
          *UsageText = "Scan Previous Track";
          break;
        case HID_USAGE_CONSUMER_STOP:
          *UsageText = "Stop";
          break;
        case HID_USAGE_CONSUMER_EJECT:
          *UsageText = "Eject";
          break;
        case HID_USAGE_CONSUMER_RANDOM_PLAY:
          *UsageText = "Random Play";
          break;
        case HID_USAGE_CONSUMER_SELECT_DISC:
          *UsageText = "Select Disc";
          break;
        case HID_USAGE_CONSUMER_ENTER_DISC:
          *UsageText = "Enter Disc";
          break;
        case HID_USAGE_CONSUMER_REPEAT:
          *UsageText = "Repeat";
          break;
        case HID_USAGE_CONSUMER_TRACKING:
          *UsageText = "Tracking";
          break;
        case HID_USAGE_CONSUMER_TRACK_NORMAL:
          *UsageText = "Track Normal";
          break;
        case HID_USAGE_CONSUMER_SLOW_TRACKING:
          *UsageText = "Slow Tracking";
          break;
        case HID_USAGE_CONSUMER_FRAME_FORWARD:
          *UsageText = "Frame Forward";
          break;
        case HID_USAGE_CONSUMER_FRAME_BACK:
          *UsageText = "Frame Back";
          break;
        case HID_USAGE_CONSUMER_MARK:
          *UsageText = "Mark";
          break;
        case HID_USAGE_CONSUMER_CLEAR_MARK:
          *UsageText = "Clear Mark";
          break;
        case HID_USAGE_CONSUMER_REPEAT_FROM_MARK:
          *UsageText = "Repeat from Mark";
          break;
        case HID_USAGE_CONSUMER_RETURN_TO_MARK:
          *UsageText = "Return to Mark";
          break;
        case HID_USAGE_CONSUMER_SEARCH_MARK_FORWARD:
          *UsageText = "Search Mark Forward";
          break;
        case HID_USAGE_CONSUMER_SEARCK_MARK_BACKWARDS:
          *UsageText = "Search Mark Backwards";
          break;
        case HID_USAGE_CONSUMER_COUNTER_RESET:
          *UsageText = "Counter Reset";
          break;
        case HID_USAGE_CONSUMER_SHOW_COUNTER:
          *UsageText = "Show Counter";
          break;
        case HID_USAGE_CONSUMER_TRACKING_INCREMENT:
          *UsageText = "Tracking Increment";
          break;
        case HID_USAGE_CONSUMER_TRACKING_DECREMENT:
          *UsageText = "Tracking Decrement";
          break;
        case HID_USAGE_CONSUMER_STOP_EJECT:
          *UsageText = "Stop/Eject";
          break;
        case HID_USAGE_CONSUMER_PLAY_PAUSE:
          *UsageText = "Play/Pause";
          break;
        case HID_USAGE_CONSUMER_PLAY_SKIP:
          *UsageText = "Play/Skip";
          break;
        case HID_USAGE_CONSUMER_VOLUME:
          *UsageText = "Volume";
          break;
        case HID_USAGE_CONSUMER_BALANCE:
          *UsageText = "Balance";
          break;
        case HID_USAGE_CONSUMER_MUTE:
          *UsageText = "Mute";
          break;
        case HID_USAGE_CONSUMER_BASS:
          *UsageText = "Bass";
          break;
        case HID_USAGE_CONSUMER_TREBLE:
          *UsageText = "Treble";
          break;
        case HID_USAGE_CONSUMER_BASS_BOOST:
          *UsageText = "Bass Boost";
          break;
        case HID_USAGE_CONSUMER_SURROUND_MODE:
          *UsageText = "Surround Mode";
          break;
        case HID_USAGE_CONSUMER_LOUDNESS:
          *UsageText = "Loudness";
          break;
        case HID_USAGE_CONSUMER_MPX:
          *UsageText = "MPX";
          break;
        case HID_USAGE_CONSUMER_VOLUME_INCREMENT:
          *UsageText = "Volume Increment";
          break;
        case HID_USAGE_CONSUMER_VOLUME_DECREMENT:
          *UsageText = "Volume Decrement";
          break;
        case HID_USAGE_CONSUMER_SPEED_SELECT:
          *UsageText = "Speed Select";
          break;
        case HID_USAGE_CONSUMER_PLAYBACK_SPEED:
          *UsageText = "Playback Speed";
          break;
        case HID_USAGE_CONSUMER_STANDARD_PLAY:
          *UsageText = "Standard Play";
          break;
        case HID_USAGE_CONSUMER_LONG_PLAY:
          *UsageText = "Long Play";
          break;
        case HID_USAGE_CONSUMER_EXTENDED_PLAY:
          *UsageText = "Extended Play";
          break;
        case HID_USAGE_CONSUMER_SLOW:
          *UsageText = "Slow";
          break;
        case HID_USAGE_CONSUMER_FAN_ENABLE:
          *UsageText = "Fan Enable";
          break;
        case HID_USAGE_CONSUMER_FAN_SPEED:
          *UsageText = "Fan Speed";
          break;
        case HID_USAGE_CONSUMER_LIGHT_ENABLE:
          *UsageText = "Light Enable";
          break;
        case HID_USAGE_CONSUMER_LIGHT_ILLUMINATION_LEVEL:
          *UsageText = "Light Illumination Level";
          break;
        case HID_USAGE_CONSUMER_CLIMATE_CONTROL_ENABLE:
          *UsageText = "Climate Control Enable";
          break;
        case HID_USAGE_CONSUMER_ROOM_TEMPERATURE:
          *UsageText = "Room Temperature";
          break;
        case HID_USAGE_CONSUMER_SECURITY_ENABLE:
          *UsageText = "Security Enable";
          break;
        case HID_USAGE_CONSUMER_FIRE_ALARM:
          *UsageText = "Fire Alarm";
          break;
        case HID_USAGE_CONSUMER_POLICE_ALARM:
          *UsageText = "Police Alarm";
          break;
        case HID_USAGE_CONSUMER_PROXIMITY:
          *UsageText = "Proximity";
          break;
        case HID_USAGE_CONSUMER_MOTION:
          *UsageText = "Motion";
          break;
        case HID_USAGE_CONSUMER_DURESS_ALARM:
          *UsageText = "Duress Alarm";
          break;
        case HID_USAGE_CONSUMER_HOLDUP_ALARM:
          *UsageText = "Holdup Alarm";
          break;
        case HID_USAGE_CONSUMER_MEDICAL_ALARM:
          *UsageText = "Medical Alarm";
          break;
        case HID_USAGE_CONSUMER_BALANCE_RIGHT:
          *UsageText = "Balance Right";
          break;
        case HID_USAGE_CONSUMER_BALANCE_LEFT:
          *UsageText = "Balance Left";
          break;
        case HID_USAGE_CONSUMER_BASS_INCREMENT:
          *UsageText = "Bass Increment";
          break;
        case HID_USAGE_CONSUMER_BASS_DECREMENT:
          *UsageText = "Bass Decrement";
          break;
        case HID_USAGE_CONSUMER_TREBLE_INCREMENT:
          *UsageText = "Treble Increment";
          break;
        case HID_USAGE_CONSUMER_TREBLE_DECREMENT:
          *UsageText = "Treble Decrement";
          break;
        case HID_USAGE_CONSUMER_SPEAKER_SYSTEM:
          *UsageText = "Speaker System";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_LEFT:
          *UsageText = "Channel Left";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_RIGHT:
          *UsageText = "Channel Right";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_CENTER:
          *UsageText = "Channel Center";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_FRONT:
          *UsageText = "Channel Front";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_CENTER_FRONT:
          *UsageText = "Channel Center Front";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_SIDE:
          *UsageText = "Channel Side";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_SURROUND:
          *UsageText = "Channel Surround";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_LOW_FREQ_ENH:
          *UsageText = "Channel Low Frequency Enhancement";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_TOP:
          *UsageText = "Channel Top";
          break;
        case HID_USAGE_CONSUMER_CHANNEL_UNKNOWN:
          *UsageText = "Channel Unknown";
          break;
        case HID_USAGE_CONSUMER_SUB_CHANNEL:
          *UsageText = "Sub-channel";
          break;
        case HID_USAGE_CONSUMER_SUB_CHANNEL_INCREMENT:
          *UsageText = "Sub-channel Increment";
          break;
        case HID_USAGE_CONSUMER_SUB_CHANNEL_DECREMENT:
          *UsageText = "Sub-channel Decrement";
          break;
        case HID_USAGE_CONSUMER_ALTERNATE_AUDIO_INCREMENT:
          *UsageText = "Alternate Audio Increment";
          break;
        case HID_USAGE_CONSUMER_ALTERNATE_AUDIO_DECREMENT:
          *UsageText = "Alternate Audio Decrement";
          break;
        case HID_USAGE_CONSUMER_APP_LAUNCH_BUTTONS:
          *UsageText = "Application Launch Buttons";
          break;
        case HID_USAGE_CONSUMER_AL_LAUNCH_BUTTON_CONFIG_TOOL:
          *UsageText = "Application Launch Button Configuration Tool";
          break;
        case HID_USAGE_CONSUMER_AL_PROG_BUTTON_CONFIG:
          *UsageText = "Application Launch Programmable Button Configuration";
          break;
        case HID_USAGE_CONSUMER_AL_CONSUMER_CONTROL_CONFIG:
          *UsageText = "Application Launch Consumer Control Configuration";
          break;
        case HID_USAGE_CONSUMER_AL_WORD_PROCESSOR:
          *UsageText = "Application Launch Word Processor";
          break;
        case HID_USAGE_CONSUMER_AL_TEXT_EDITOR:
          *UsageText = "Application Launch Text Editor";
          break;
        case HID_USAGE_CONSUMER_AL_SPREADSHEET:
          *UsageText = "Application Launch Spreadsheet";
          break;
        case HID_USAGE_CONSUMER_AL_GRAPHICS_EDITOR:
          *UsageText = "Application Launch Graphics Editor";
          break;
        case HID_USAGE_CONSUMER_AL_PRESENTATION_APP:
          *UsageText = "Application Launch Presentation Application";
          break;
        case HID_USAGE_CONSUMER_AL_DATABASE_APP:
          *UsageText = "Application Launch Database Application";
          break;
        case HID_USAGE_CONSUMER_AL_EMAIL_READER:
          *UsageText = "Application Launch Email Reader";
          break;
        case HID_USAGE_CONSUMER_AL_NEWSREADER:
          *UsageText = "Application Launch Newsreader";
          break;
        case HID_USAGE_CONSUMER_AL_VOICEMAIL:
          *UsageText = "Application Launch Voicemail";
          break;
        case HID_USAGE_CONSUMER_AL_CONTACTS_ADDESSBOOK:
          *UsageText = "Application Launch Contacts/Addressbook";
          break;
        case HID_USAGE_CONSUMER_AL_CALENDAR_SCHEDULE:
          *UsageText = "Application Launch Calendar/Schedule";
          break;
        case HID_USAGE_CONSUMER_AL_TASK_PROJECT_MANAGER:
          *UsageText = "Application Launch Task/Project Manager";
          break;
        case HID_USAGE_CONSUMER_AL_LOG_JOURNAL_TIMECARD:
          *UsageText = "Application Launch Log/Journal/Timecard";
          break;
        case HID_USAGE_CONSUMER_AL_CHECKBOOK_FINANCE:
          *UsageText = "Application Launch Checkbook/Finance";
          break;
        case HID_USAGE_CONSUMER_AL_CALCULATOR:
          *UsageText = "Application Launch Calculator";
          break;
        case HID_USAGE_CONSUMER_AL_AV_CAPTURE_PLAYBACK:
          *UsageText = "Application Launch A/V Capture/Playback";
          break;
        case HID_USAGE_CONSUMER_AL_LOCAL_MACHINE_BROWSER:
          *UsageText = "Application Launch Local Machine Browser";
          break;
        case HID_USAGE_CONSUMER_AL_LAN_WAN_BROWSER:
          *UsageText = "Application Launch LAN/WAN Browser";
          break;
        case HID_USAGE_CONSUMER_AL_INTERNET_BROWSER:
          *UsageText = "Application Launch Internet Browser";
          break;
        case HID_USAGE_CONSUMER_AL_REMOTE_NETWORKING_ISP_CONNECT:
          *UsageText = "Application Launch Remote Networking/ISP Connect";
          break;
        case HID_USAGE_CONSUMER_AL_NETWORK_CONFERENCE:
          *UsageText = "Application Launch Network Conference";
          break;
        case HID_USAGE_CONSUMER_AL_NETWORK_CHAT:
          *UsageText = "Application Launch Network Chat";
          break;
        case HID_USAGE_CONSUMER_AL_TELEPHONY_DIALER:
          *UsageText = "Application Launch Telephony/Dialer";
          break;
        case HID_USAGE_CONSUMER_AL_LOGON:
          *UsageText = "Application Launch Logon";
          break;
        case HID_USAGE_CONSUMER_AL_LOGOFF:
          *UsageText = "Application Launch Logoff";
          break;
        case HID_USAGE_CONSUMER_AL_LOGON_LOGOFF:
          *UsageText = "Application Launch Logon/Logoff";
          break;
        case HID_USAGE_CONSUMER_AL_TERMINAL_LOCK_SCREENSAVER:
          *UsageText = "Application Launch Terminal Lock/Screensaver";
          break;
        case HID_USAGE_CONSUMER_AL_CONTROL_PANEL:
          *UsageText = "Application Launch Control Panel";
          break;
        case HID_USAGE_CONSUMER_AL_COMMAND_LINE_PROCESSOR_RUN:
          *UsageText = "Application Launch Command Line Processor/Run";
          break;
        case HID_USAGE_CONSUMER_AL_PROCESS_TASK_MANAGER:
          *UsageText = "Application Launch Process/Task Manager";
          break;
        case HID_USAGE_CONSUMER_AL_SELECT_TASK_APP:
          *UsageText = "Application Launch Select Task/Application";
          break;
        case HID_USAGE_CONSUMER_AL_NEXT_TASK_APP:
          *UsageText = "Application Launch Next Task/Application";
          break;
        case HID_USAGE_CONSUMER_AL_PREV_TASK_APP:
          *UsageText = "Application Launch Previous Task/Application";
          break;
        case HID_USAGE_CONSUMER_AL_PREEMPTIVE_HALT_TASK_APP:
          *UsageText = "Application Launch Preemptive Halt Task/Application";
          break;
        case HID_USAGE_CONSUMER_AL_INTEGRATED_HELP_CENTER:
          *UsageText = "Application Launch Integrated Help Center";
          break;
        case HID_USAGE_CONSUMER_AL_DOCUMENTS:
          *UsageText = "Application Launch Documents";
          break;
        case HID_USAGE_CONSUMER_AL_THESAURUS:
          *UsageText = "Application Launch Thesaurus";
          break;
        case HID_USAGE_CONSUMER_AL_DICTIONARY:
          *UsageText = "Application Launch Dictionary";
          break;
        case HID_USAGE_CONSUMER_AL_DESKTOP:
          *UsageText = "Application Launch Desktop";
          break;
        case HID_USAGE_CONSUMER_AL_SPELL_CHECK:
          *UsageText = "Application Launch Spell Check";
          break;
        case HID_USAGE_CONSUMER_AL_GRAMMAR_CHECK:
          *UsageText = "Application Launch Grammar Check";
          break;
        case HID_USAGE_CONSUMER_AL_WIRELESS_STATUS:
          *UsageText = "Application Launch Wireless Status";
          break;
        case HID_USAGE_CONSUMER_AL_KEYBOARD_LAYOUT:
          *UsageText = "Application Launch Keyboard Layout";
          break;
        case HID_USAGE_CONSUMER_AL_VIRUS_PROTECTION:
          *UsageText = "Application Launch Virus Protection";
          break;
        case HID_USAGE_CONSUMER_AL_ENCRYPTION:
          *UsageText = "Application Launch Encryption";
          break;
        case HID_USAGE_CONSUMER_AL_SCREENSAVER:
          *UsageText = "Application Launch Screensaver";
          break;
        case HID_USAGE_CONSUMER_AL_ALARMS:
          *UsageText = "Application Launch Alarms";
          break;
        case HID_USAGE_CONSUMER_AL_CLOCK:
          *UsageText = "Application Launch Clock";
          break;
        case HID_USAGE_CONSUMER_AL_FILE_BROWSER:
          *UsageText = "Application Launch File Browser";
          break;
        case HID_USAGE_CONSUMER_AL_POWER_STATUS:
          *UsageText = "Application Launch Power Status";
          break;
        case HID_USAGE_CONSUMER_GENERIC_GUI_APP_CONTROLS:
          *UsageText = "Generic GUI Application Controls";
          break;
        case HID_USAGE_CONSUMER_AC_NEW:
          *UsageText = "Application Control New";
          break;
        case HID_USAGE_CONSUMER_AC_OPEN:
          *UsageText = "Application Control Open";
          break;
        case HID_USAGE_CONSUMER_AC_CLOSE:
          *UsageText = "Application Control Cose";
          break;
        case HID_USAGE_CONSUMER_AC_EXIT:
          *UsageText = "Application Control Exit";
          break;
        case HID_USAGE_CONSUMER_AC_MAXIMIZE:
          *UsageText = "Application Control Maximize";
          break;
        case HID_USAGE_CONSUMER_AC_MINIMIZE:
          *UsageText = "Application Control Minimize";
          break;
        case HID_USAGE_CONSUMER_AC_SAVE:
          *UsageText = "Application Control Save";
          break;
        case HID_USAGE_CONSUMER_AC_PRINT:
          *UsageText = "Application Control Print";
          break;
        case HID_USAGE_CONSUMER_AC_PROPERTIES:
          *UsageText = "Application Control Properties";
          break;
        case HID_USAGE_CONSUMER_AC_UNDO:
          *UsageText = "Application Control Undo";
          break;
        case HID_USAGE_CONSUMER_AC_COPY:
          *UsageText = "Application Control Copy";
          break;
        case HID_USAGE_CONSUMER_AC_CUT:
          *UsageText = "Application Control Cut";
          break;
        case HID_USAGE_CONSUMER_AC_PASTE:
          *UsageText = "Application Control Paste";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_ALL:
          *UsageText = "Application Control Select All";
          break;
        case HID_USAGE_CONSUMER_AC_FIND:
          *UsageText = "Application Control Find";
          break;
        case HID_USAGE_CONSUMER_AC_FIND_AND_REPLACE:
          *UsageText = "Application Control Find and Replace";
          break;
        case HID_USAGE_CONSUMER_AC_SEARCH:
          *UsageText = "Application Control Search";
          break;
        case HID_USAGE_CONSUMER_AC_GO_TO:
          *UsageText = "Application Control Go To";
          break;
        case HID_USAGE_CONSUMER_AC_HOME:
          *UsageText = "Application Control Home";
          break;
        case HID_USAGE_CONSUMER_AC_BACK:
          *UsageText = "Application Control Back";
          break;
        case HID_USAGE_CONSUMER_AC_FORWARD:
          *UsageText = "Application Control Forward";
          break;
        case HID_USAGE_CONSUMER_AC_STOP:
          *UsageText = "Application Control Stop";
          break;
        case HID_USAGE_CONSUMER_AC_REFRESH:
          *UsageText = "Application Control Refresh";
          break;
        case HID_USAGE_CONSUMER_AC_PREV_LINK:
          *UsageText = "Application Control Previous Link";
          break;
        case HID_USAGE_CONSUMER_AC_NEXT_LINK:
          *UsageText = "Application Control Next Link";
          break;
        case HID_USAGE_CONSUMER_AC_BOOKMARKS:
          *UsageText = "Application Control Bookmarks";
          break;
        case HID_USAGE_CONSUMER_AC_HISTORY:
          *UsageText = "Application Control History";
          break;
        case HID_USAGE_CONSUMER_AC_SUBSCRIPTIONS:
          *UsageText = "Application Control Subscriptions";
          break;
        case HID_USAGE_CONSUMER_AC_ZOOM_IN:
          *UsageText = "Application Control Zoom In";
          break;
        case HID_USAGE_CONSUMER_AC_ZOOM_OUT:
          *UsageText = "Application Control Zoom Out";
          break;
        case HID_USAGE_CONSUMER_AC_ZOOM:
          *UsageText = "Application Control Zoom";
          break;
        case HID_USAGE_CONSUMER_AC_FULL_SCREEN_VIEW:
          *UsageText = "Application Control Full Screen View";
          break;
        case HID_USAGE_CONSUMER_AC_NORMAL_VIEW:
          *UsageText = "Application Control Normal View";
          break;
        case HID_USAGE_CONSUMER_AC_VIEW_TOGGLE:
          *UsageText = "Application Control View Toggle";
          break;
        case HID_USAGE_CONSUMER_AC_SCROLL_UP:
          *UsageText = "Application Control Scroll Up";
          break;
        case HID_USAGE_CONSUMER_AC_SCROLL_DOWN:
          *UsageText = "Application Control Scroll Down";
          break;
        case HID_USAGE_CONSUMER_AC_SCROLL:
          *UsageText = "Application Control Scroll";
          break;
        case HID_USAGE_CONSUMER_AC_PAN_LEFT:
          *UsageText = "Application Control Pan Left";
          break;
        case HID_USAGE_CONSUMER_AC_PAN_RIGHT:
          *UsageText = "Application Control Pan Right";
          break;
        case HID_USAGE_CONSUMER_AC_PAN:
          *UsageText = "Application Control Pan";
          break;
        case HID_USAGE_CONSUMER_AC_NEW_WINDOW:
          *UsageText = "Application Control New Window";
          break;
        case HID_USAGE_CONSUMER_AC_TILE_HORIZONTALLY:
          *UsageText = "Application Control Tile Horizontally";
          break;
        case HID_USAGE_CONSUMER_AC_TILE_VERTICALLY:
          *UsageText = "Application Control Tile Vertically";
          break;
        case HID_USAGE_CONSUMER_AC_FORMAT:
          *UsageText = "Application Control Format";
          break;
        case HID_USAGE_CONSUMER_AC_EDIT:
          *UsageText = "Application Control Edit";
          break;
        case HID_USAGE_CONSUMER_AC_BOLD:
          *UsageText = "Application Control Bold";
          break;
        case HID_USAGE_CONSUMER_AC_ITALICS:
          *UsageText = "Application Control Italics";
          break;
        case HID_USAGE_CONSUMER_AC_UNDERLINE:
          *UsageText = "Application Control Underline";
          break;
        case HID_USAGE_CONSUMER_AC_STRIKETHROUGH:
          *UsageText = "Application Control Strikethrough";
          break;
        case HID_USAGE_CONSUMER_AC_SUBSCRIPT:
          *UsageText = "Application Control Subscript";
          break;
        case HID_USAGE_CONSUMER_AC_SUPERSCRIPT:
          *UsageText = "Application Control Superscript";
          break;
        case HID_USAGE_CONSUMER_AC_ALL_CAPS:
          *UsageText = "Application Control All Caps";
          break;
        case HID_USAGE_CONSUMER_AC_ROTATE:
          *UsageText = "Application Control Rotate";
          break;
        case HID_USAGE_CONSUMER_AC_RESIZE:
          *UsageText = "Application Control Resize";
          break;
        case HID_USAGE_CONSUMER_AC_FLIP_HORIZONTAL:
          *UsageText = "Application Control Flip Horizontal";
          break;
        case HID_USAGE_CONSUMER_AC_FLIP_VERTICAL:
          *UsageText = "Application Control Flip Vertical";
          break;
        case HID_USAGE_CONSUMER_AC_MIRROR_HORIZONTAL:
          *UsageText = "Application Control Mirror Horizontal";
          break;
        case HID_USAGE_CONSUMER_AC_MIRROR_VERTICAL:
          *UsageText = "Application Control Mirror Vertical";
          break;
        case HID_USAGE_CONSUMER_AC_FONT_SELECT:
          *UsageText = "Application Control Font Select";
          break;
        case HID_USAGE_CONSUMER_AC_FONT_COLOR:
          *UsageText = "Application Control Font Color";
          break;
        case HID_USAGE_CONSUMER_AC_FONT_SIZE:
          *UsageText = "Application Control Font Size";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_LEFT:
          *UsageText = "Application Control Justify Left";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_CENTER_H:
          *UsageText = "Application Control Justify Center Horizontally";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_RIGHT:
          *UsageText = "Application Control Justify Right";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_BLOCK_H:
          *UsageText = "Application Control Justify Block Horizontally";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_TOP:
          *UsageText = "Application Control Justify Top";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_CENTER_V:
          *UsageText = "Application Control Justify Center Vertically";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_BOTTOM:
          *UsageText = "Application Control Justify Bottom";
          break;
        case HID_USAGE_CONSUMER_AC_JUSTIFY_BLOCK_V:
          *UsageText = "Application Control Justify Block Vertically";
          break;
        case HID_USAGE_CONSUMER_AC_INDENT_DECREASE:
          *UsageText = "Application Control Indent Decrease";
          break;
        case HID_USAGE_CONSUMER_AC_INDENT_INCREASE:
          *UsageText = "Application Control Indent Increase";
          break;
        case HID_USAGE_CONSUMER_AC_NUMBERED_LIST:
          *UsageText = "Application Control Numbered List";
          break;
        case HID_USAGE_CONSUMER_AC_RESTART_NUMBERING:
          *UsageText = "Application Control Restart Numbering";
          break;
        case HID_USAGE_CONSUMER_AC_BULLETED_LIST:
          *UsageText = "Application Control Bulleted List";
          break;
        case HID_USAGE_CONSUMER_AC_PROMOTE:
          *UsageText = "Application Control Promote";
          break;
        case HID_USAGE_CONSUMER_AC_DEMOTE:
          *UsageText = "Application Control Demote";
          break;
        case HID_USAGE_CONSUMER_AC_YES:
          *UsageText = "Application Control Yes";
          break;
        case HID_USAGE_CONSUMER_AC_NO:
          *UsageText = "Application Control No";
          break;
        case HID_USAGE_CONSUMER_AC_CANCEL:
          *UsageText = "Application Control Cancel";
          break;
        case HID_USAGE_CONSUMER_AC_CATALOG:
          *UsageText = "Application Control Catalog";
          break;
        case HID_USAGE_CONSUMER_AC_BUY_CHECKOUT:
          *UsageText = "Application Control Buy Checkout";
          break;
        case HID_USAGE_CONSUMER_AC_ADD_TO_CART:
          *UsageText = "Application Control Add To Cart";
          break;
        case HID_USAGE_CONSUMER_AC_EXPAND:
          *UsageText = "Application Control Expand";
          break;
        case HID_USAGE_CONSUMER_AC_EXPAND_ALL:
          *UsageText = "Application Control Expand All";
          break;
        case HID_USAGE_CONSUMER_AC_COLLAPSE:
          *UsageText = "Application Control Collapse";
          break;
        case HID_USAGE_CONSUMER_AC_COLLAPSE_ALL:
          *UsageText = "Application Control Collapse All";
          break;
        case HID_USAGE_CONSUMER_AC_PRINT_PREVIEW:
          *UsageText = "Application Control Print Preview";
          break;
        case HID_USAGE_CONSUMER_AC_PASTE_SPECIAL:
          *UsageText = "Application Control Paste Special";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_MODE:
          *UsageText = "Application Control Insert Mode";
          break;
        case HID_USAGE_CONSUMER_AC_DELETE:
          *UsageText = "Application Control Delete";
          break;
        case HID_USAGE_CONSUMER_AC_LOCK:
          *UsageText = "Application Control Lock";
          break;
        case HID_USAGE_CONSUMER_AC_UNLOCK:
          *UsageText = "Application Control Unlock";
          break;
        case HID_USAGE_CONSUMER_AC_PROTECT:
          *UsageText = "Application Control Protect";
          break;
        case HID_USAGE_CONSUMER_AC_UNPROTECT:
          *UsageText = "Application Control Unprotect";
          break;
        case HID_USAGE_CONSUMER_AC_ATTACH_COMMENT:
          *UsageText = "Application Control Attach Comment";
          break;
        case HID_USAGE_CONSUMER_AC_DELETE_COMMENT:
          *UsageText = "Application Control Delete Comment";
          break;
        case HID_USAGE_CONSUMER_AC_VIEW_COMMENT:
          *UsageText = "Application Control View Comment";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_WORD:
          *UsageText = "Application Control Select Word";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_SENTENCE:
          *UsageText = "Application Control Select Sentence";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_PARAGRAPH:
          *UsageText = "Application Control Select Paragraph";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_COLUMN:
          *UsageText = "Application Control Select Column";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_ROW:
          *UsageText = "Application Control Select Row";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_TABLE:
          *UsageText = "Application Control Select Table";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_OBJECT:
          *UsageText = "Application Control Select Object";
          break;
        case HID_USAGE_CONSUMER_AC_REDO_REPEAT:
          *UsageText = "Application Control Redo/Repeat";
          break;
        case HID_USAGE_CONSUMER_AC_SORT:
          *UsageText = "Application Control Sort";
          break;
        case HID_USAGE_CONSUMER_AC_SORT_ASCENDING:
          *UsageText = "Application Control Sort Ascending";
          break;
        case HID_USAGE_CONSUMER_AC_SORT_DESCENDING:
          *UsageText = "Application Control Sort Descending";
          break;
        case HID_USAGE_CONSUMER_AC_FILTER:
          *UsageText = "Application Control Filter";
          break;
        case HID_USAGE_CONSUMER_AC_SET_CLOCK:
          *UsageText = "Application Control Set Clock";
          break;
        case HID_USAGE_CONSUMER_AC_VIEW_CLOCK:
          *UsageText = "Application Control View Clock";
          break;
        case HID_USAGE_CONSUMER_AC_SELECT_TIME_ZONE:
          *UsageText = "Application Control Select Time Zone";
          break;
        case HID_USAGE_CONSUMER_AC_EDIT_TIME_ZONES:
          *UsageText = "Application Control Edit Time Zones";
          break;
        case HID_USAGE_CONSUMER_AC_SET_ALARM:
          *UsageText = "Application Control Set Alarm";
          break;
        case HID_USAGE_CONSUMER_AC_CLEAR_ALARM:
          *UsageText = "Application Control Clear Alarm";
          break;
        case HID_USAGE_CONSUMER_AC_SNOOZE_ALARM:
          *UsageText = "Application Control Snooze Alarm";
          break;
        case HID_USAGE_CONSUMER_AC_RESET_ALARM:
          *UsageText = "Application Control Reset Alarm";
          break;
        case HID_USAGE_CONSUMER_AC_SYNCHRONIZE:
          *UsageText = "Application Control Synchronize";
          break;
        case HID_USAGE_CONSUMER_AC_SEND_RECEIVE:
          *UsageText = "Application Control Send/Receive";
          break;
        case HID_USAGE_CONSUMER_AC_SEND_TO:
          *UsageText = "Application Control Send To";
          break;
        case HID_USAGE_CONSUMER_AC_REPLY:
          *UsageText = "Application Control Reply";
          break;
        case HID_USAGE_CONSUMER_AC_REPLY_ALL:
          *UsageText = "Application Control Reply All";
          break;
        case HID_USAGE_CONSUMER_AC_FORWARD_MSG:
          *UsageText = "Application Control Forward Message";
          break;
        case HID_USAGE_CONSUMER_AC_SEND:
          *UsageText = "Application Control Send";
          break;
        case HID_USAGE_CONSUMER_AC_ATTACH_FILE:
          *UsageText = "Application Control Attach File";
          break;
        case HID_USAGE_CONSUMER_AC_UPLOAD:
          *UsageText = "Application Control Upload";
          break;
        case HID_USAGE_CONSUMER_AC_DOWNLOAD:
          *UsageText = "Application Control Download";
          break;
        case HID_USAGE_CONSUMER_AC_SET_BORDERS:
          *UsageText = "Application Control Set Borders";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_ROW:
          *UsageText = "Application Control Insert Row";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_COLUMN:
          *UsageText = "Application Control Insert Column";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_FILE:
          *UsageText = "Application Control Insert File";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_PICTURE:
          *UsageText = "Application Control Insert Picture";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_OBJECT:
          *UsageText = "Application Control Insert Object";
          break;
        case HID_USAGE_CONSUMER_AC_INSERT_SYMBOL:
          *UsageText = "Application Control Insert Symbol";
          break;
        case HID_USAGE_CONSUMER_AC_SAVE_AND_CLOSE:
          *UsageText = "Application Control Save and Close";
          break;
        case HID_USAGE_CONSUMER_AC_RENAME:
          *UsageText = "Application Control Rename";
          break;
        case HID_USAGE_CONSUMER_AC_MERGE:
          *UsageText = "Application Control Merge";
          break;
        case HID_USAGE_CONSUMER_AC_SPLIT:
          *UsageText = "Application Control Split";
          break;
        case HID_USAGE_CONSUMER_AC_DISTRIBUTE_HORIZONTALLY:
          *UsageText = "Application Control Distribute Horizontally";
          break;
        case HID_USAGE_CONSUMER_AC_DISTRIBUTE_VERTICALLY:
          *UsageText = "Application Control Distribute Vertically";
          break;
      }
      break;
    case HID_USAGE_PAGE_DIGITIZER:
      *UsagePageText = "Digitizer";
      switch(Usage)
      {
        case HID_USAGE_DIGITIZER_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_DIGITIZER_DIGITIZER:
          *UsageText = "Digitizer";
          break;
        case HID_USAGE_DIGITIZER_PEN:
          *UsageText = "Pen";
          break;
        case HID_USAGE_DIGITIZER_LIGHT_PEN:
          *UsageText = "Light Pen";
          break;
        case HID_USAGE_DIGITIZER_TOUCH_SCREEN:
          *UsageText = "Touch Screen";
          break;
        case HID_USAGE_DIGITIZER_TOUCH_PAD:
          *UsageText = "Touch Pad";
          break;
        case HID_USAGE_DIGITIZER_WHITE_BOARD:
          *UsageText = "White Board";
          break;
        case HID_USAGE_DIGITIZER_COORDINATE_MEASURING_MACHINE:
          *UsageText = "Coordinate Measuring Machine";
          break;
        case HID_USAGE_DIGITIZER_3D_DIGITIZER:
          *UsageText = "3D Digitizer";
          break;
        case HID_USAGE_DIGITIZER_STEREO_PLOTTER:
          *UsageText = "Stereo Plotter";
          break;
        case HID_USAGE_DIGITIZER_ARTICULATED_ARM:
          *UsageText = "Articulated Arm";
          break;
        case HID_USAGE_DIGITIZER_ARMATURE:
          *UsageText = "Armature";
          break;
        case HID_USAGE_DIGITIZER_MULTIPLE_POINT_DIGITIZER:
          *UsageText = "Multiple Point Digitizer";
          break;
        case HID_USAGE_DIGITIZER_FREE_SPACE_WAND:
          *UsageText = "Free Space Wand";
          break;
        case HID_USAGE_DIGITIZER_STYLUS:
          *UsageText = "Stylus";
          break;
        case HID_USAGE_DIGITIZER_PUCK:
          *UsageText = "Puck";
          break;
        case HID_USAGE_DIGITIZER_FINGER:
          *UsageText = "Finger";
          break;
        case HID_USAGE_DIGITIZER_TIP_PRESSURE:
          *UsageText = "Tip Pressure";
          break;
        case HID_USAGE_DIGITIZER_BARREL_PRESSURE:
          *UsageText = "Barrel Pressure";
          break;
        case HID_USAGE_DIGITIZER_IN_RANGE:
          *UsageText = "In Range";
          break;
        case HID_USAGE_DIGITIZER_TOUCH:
          *UsageText = "Touch";
          break;
        case HID_USAGE_DIGITIZER_UNTOUCH:
          *UsageText = "Untouch";
          break;
        case HID_USAGE_DIGITIZER_TAP:
          *UsageText = "Tap";
          break;
        case HID_USAGE_DIGITIZER_QUALITY:
          *UsageText = "Quality";
          break;
        case HID_USAGE_DIGITIZER_DATA_VALID:
          *UsageText = "Data Valid";
          break;
        case HID_USAGE_DIGITIZER_TRANSDUCER_INDEX:
          *UsageText = "Transducer Index";
          break;
        case HID_USAGE_DIGITIZER_TABLET_FUNCTION_KEYS:
          *UsageText = "Tablet Function Keys";
          break;
        case HID_USAGE_DIGITIZER_PROGRAM_CHANGE_KEYS:
          *UsageText = "Program Change Keys";
          break;
        case HID_USAGE_DIGITIZER_BATTERY_STRENGTH:
          *UsageText = "Battery Strength";
          break;
        case HID_USAGE_DIGITIZER_INVERT:
          *UsageText = "Invert";
          break;
        case HID_USAGE_DIGITIZER_X_TILT:
          *UsageText = "X Tilt";
          break;
        case HID_USAGE_DIGITIZER_Y_TILT:
          *UsageText = "Y Tilt";
          break;
        case HID_USAGE_DIGITIZER_AZIMUTH:
          *UsageText = "Azimuth";
          break;
        case HID_USAGE_DIGITIZER_ALTITUDE:
          *UsageText = "Altitude";
          break;
        case HID_USAGE_DIGITIZER_TWIST:
          *UsageText = "Twist";
          break;
        case HID_USAGE_DIGITIZER_TIP_SWITCH:
          *UsageText = "Tip Switch";
          break;
        case HID_USAGE_DIGITIZER_SECONDARY_TIP_SWITCH:
          *UsageText = "Secondary Tip Switch";
          break;
        case HID_USAGE_DIGITIZER_BARREL_SWITCH:
          *UsageText = "Barrel Switch";
          break;
        case HID_USAGE_DIGITIZER_ERASER:
          *UsageText = "Eraser";
          break;
        case HID_USAGE_DIGITIZER_TABLET_PICK:
          *UsageText = "Tablet Pick";
          break;
      }
      break;
    case HID_USAGE_PAGE_PHYSICAL_INPUT_DEVICE:
      *UsagePageText = "Physical Input Device (Force Feedback)";
      switch(Usage)
      {
        case HID_USAGE_PID_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_PID_PHYSICAL_INTERFACE_DEVICE:
          *UsageText = "Physical Interface Device";
          break;
        case HID_USAGE_PID_NORMAL:
          *UsageText = "Normal";
          break;
        case HID_USAGE_PID_SET_EFFECT_REPORT:
          *UsageText = "Set Effect Report";
          break;
        case HID_USAGE_PID_EFFECT_BLOCK_INDEX:
          *UsageText = "Effect Block Index";
          break;
        case HID_USAGE_PID_PARAMETER_BLOCK_OFFSET:
          *UsageText = "Parameter Block Offset";
          break;
        case HID_USAGE_PID_ROM_FLAG:
          *UsageText = "ROM Flag";
          break;
        case HID_USAGE_PID_EFFECT_TYPE:
          *UsageText = "Effect Type";
          break;
        case HID_USAGE_PID_ET_CONSTANT_FORCE:
          *UsageText = "Effect Type Constant Force";
          break;
        case HID_USAGE_PID_ET_RAMP:
          *UsageText = "Effect Type Ramp";
          break;
        case HID_USAGE_PID_ET_CUSTOM_FORCE_DATA:
          *UsageText = "Effect Type Custom Force Data";
          break;
        case HID_USAGE_PID_ET_SQUARE:
          *UsageText = "Effect Type Square";
          break;
        case HID_USAGE_PID_ET_SINE:
          *UsageText = "Effect Type Sine";
          break;
        case HID_USAGE_PID_ET_TRIANGLE:
          *UsageText = "Effect Type Triangle";
          break;
        case HID_USAGE_PID_ET_SAWTOOTH_UP:
          *UsageText = "Effect Type Sawtooth Up";
          break;
        case HID_USAGE_PID_ET_SAWTOOTH_DOWN:
          *UsageText = "Effect Type Sawtooth Down";
          break;
        case HID_USAGE_PID_ET_SPRING:
          *UsageText = "Effect Type Spring";
          break;
        case HID_USAGE_PID_ET_DAMPER:
          *UsageText = "Effect Type Damper";
          break;
        case HID_USAGE_PID_ET_INERTIA:
          *UsageText = "Effect Type Inertia";
          break;
        case HID_USAGE_PID_ET_FRICTION:
          *UsageText = "Effect Type Friction";
          break;
        case HID_USAGE_PID_DURATION:
          *UsageText = "Duration";
          break;
        case HID_USAGE_PID_SAMPLE_PERIOD:
          *UsageText = "Sample Period";
          break;
        case HID_USAGE_PID_GAIN:
          *UsageText = "Gain";
          break;
        case HID_USAGE_PID_TRIGGER_BUTTON:
          *UsageText = "Trigger Button";
          break;
        case HID_USAGE_PID_TRIGGER_REPEAT_INTERVAL:
          *UsageText = "Trigger Repeat Interval";
          break;
        case HID_USAGE_PID_AXES_ENABLE:
          *UsageText = "Axes Enable";
          break;
        case HID_USAGE_PID_DIRECTION_ENABLE:
          *UsageText = "Direction Enable";
          break;
        case HID_USAGE_PID_DIRECTION:
          *UsageText = "Direction";
          break;
        case HID_USAGE_PID_TYPE_SPECIFIC_BLOCK_OFFSET:
          *UsageText = "Type Specific Block Offset";
          break;
        case HID_USAGE_PID_BLOCK_TYPE:
          *UsageText = "Block Type";
          break;
        case HID_USAGE_PID_SET_ENVELOPE_REPORT:
          *UsageText = "Set Envelope Report";
          break;
        case HID_USAGE_PID_ATTACK_LEVEL:
          *UsageText = "Attack Level";
          break;
        case HID_USAGE_PID_ATTACK_TIME:
          *UsageText = "Attack Time";
          break;
        case HID_USAGE_PID_FADE_LEVEL:
          *UsageText = "Fade Level";
          break;
        case HID_USAGE_PID_FADE_TIME:
          *UsageText = "Fade Time";
          break;
        case HID_USAGE_PID_SET_CONDITION_REPORT:
          *UsageText = "Set Condition Report";
          break;
        case HID_USAGE_PID_CP_OFFSET:
          *UsageText = "CP Offset";
          break;
        case HID_USAGE_PID_POSITIVE_COEFFICIENT:
          *UsageText = "Positive Coefficient";
          break;
        case HID_USAGE_PID_NEGATIVE_COEFFICIENT:
          *UsageText = "Negative Coefficient";
          break;
        case HID_USAGE_PID_POSITIVE_SATURATION:
          *UsageText = "Positive Saturation";
          break;
        case HID_USAGE_PID_NEGATIVE_SATURATION:
          *UsageText = "Negative Saturation";
          break;
        case HID_USAGE_PID_DEAD_BAND:
           *UsageText = "Dead Band";
           break;
       case HID_USAGE_PID_DOWNLOAD_FORCE_SAMPLE:
          *UsageText = "Download Force Sample";
          break;
        case HID_USAGE_PID_ISOCH_CUSTOM_FORCE_ENABLE:
          *UsageText = "Isoch Custom Force Enable";
          break;
        case HID_USAGE_PID_CUSTOM_FORCE_DATA_REPORT:
          *UsageText = "Custom Force Data Report";
          break;
        case HID_USAGE_PID_CUSTOM_FORCE_DATA:
          *UsageText = "Custom Force Data";
          break;
        case HID_USAGE_PID_CUSTOM_FORCE_VENDOR_DEFINED_DATA:
          *UsageText = "Custom Force Vendor Defined Data";
          break;
        case HID_USAGE_PID_SET_CUSTOM_FORCE_REPORT:
          *UsageText = "Set Custom Force Report";
          break;
        case HID_USAGE_PID_CUSTOM_FORCE_DATA_OFFSET:
          *UsageText = "Custom Force Data Report";
          break;
        case HID_USAGE_PID_SAMPLE_COUNT:
          *UsageText = "Sample Count";
          break;
        case HID_USAGE_PID_SET_PERIODIC_REPORT:
          *UsageText = "Set Periodic Report";
          break;
        case HID_USAGE_PID_OFFSET:
          *UsageText = "Offset";
          break;
        case HID_USAGE_PID_MAGNITUDE:
          *UsageText = "Magnitude";
          break;
        case HID_USAGE_PID_PHASE:
          *UsageText = "Phase";
          break;
        case HID_USAGE_PID_PERIOD:
          *UsageText = "Period";
          break;
        case HID_USAGE_PID_SET_CONSTANT_FORCE_REPORT:
          *UsageText = "Set Constant Force Report";
          break;
        case HID_USAGE_PID_SET_RAMP_FORCE_REPORT:
          *UsageText = "Set Ramp Force Report";
          break;
        case HID_USAGE_PID_RAMP_START:
          *UsageText = "Ramp Start";
          break;
        case HID_USAGE_PID_RAMP_END:
          *UsageText = "Ramp Stop";
          break;
        case HID_USAGE_PID_EFFECT_OPERATION_REPORT:
          *UsageText = "Effect Operation Report";
          break;
        case HID_USAGE_PID_EFFECT_OPERATION:
          *UsageText = "Effect Operation";
          break;
        case HID_USAGE_PID_OP_EFFECT_START:
          *UsageText = "OP Effect Start";
          break;
        case HID_USAGE_PID_OP_EFFECT_START_SOLO:
          *UsageText = "OP Effect Start Solo";
          break;
        case HID_USAGE_PID_OP_EFFECT_STOP:
          *UsageText = "OP Effect Stop";
          break;
        case HID_USAGE_PID_LOOP_COUNT:
          *UsageText = "Loop Count";
          break;
        case HID_USAGE_PID_DEVICE_GAIN_REPORT:
          *UsageText = "Device Gain Report";
          break;
        case HID_USAGE_PID_DEVICE_GAIN:
          *UsageText = "Device Gain";
          break;
        case HID_USAGE_PID_PID_POOL_REPORT:
          *UsageText = "Pool Report";
          break;
        case HID_USAGE_PID_RAM_POOL_SIZE:
          *UsageText = "RAM Pool Size";
          break;
        case HID_USAGE_PID_ROM_POOL_SIZE:
          *UsageText = "ROM Pool Size";
          break;
        case HID_USAGE_PID_ROM_EFFECT_BLOCK_COUNT:
          *UsageText = "Effect Block Count";
          break;
        case HID_USAGE_PID_SIMULTANEOUS_EFFECTS_MAX:
          *UsageText = "Simultaneous Effects Max";
          break;
        case HID_USAGE_PID_POOL_ALIGNMENT:
          *UsageText = "Pool Alignment";
          break;
        case HID_USAGE_PID_PID_POOL_MOVE_REPORT:
          *UsageText = "Pool Move Report";
          break;
        case HID_USAGE_PID_MOVE_SOURCE:
          *UsageText = "Move Source";
          break;
        case HID_USAGE_PID_MOVE_DESTINATION:
          *UsageText = "Move Destination";
          break;
        case HID_USAGE_PID_MOVE_LENGTH:
          *UsageText = "Move Length";
          break;
        case HID_USAGE_PID_PID_BLOCK_LOAD_REPORT:
          *UsageText = "PID Block Load Report";
          break;
        case HID_USAGE_PID_BLOCK_LOAD_STATUS:
          *UsageText = "Block Load Status";
          break;
        case HID_USAGE_PID_BLOCK_LOAD_SUCCESS:
          *UsageText = "Load Success";
          break;
        case HID_USAGE_PID_BLOCK_LOAD_FULL:
          *UsageText = "Load Full";
          break;
        case HID_USAGE_PID_BLOCK_LOAD_ERROR:
          *UsageText = "Load Error";
          break;
        case HID_USAGE_PID_BLOCK_HANDLE:
          *UsageText = "Block Handle";
          break;
        case HID_USAGE_PID_PID_BLOCK_FREE_REPORT:
          *UsageText = "PID Block Free Report";
          break;
        case HID_USAGE_PID_TYPE_SPECIFIC_BLOCK_HANDLE:
          *UsageText = "Type Specific Block Handle";
          break;
        case HID_USAGE_PID_PID_STATE_REPORT:
          *UsageText = "PID State Report";
          break;
        case HID_USAGE_PID_EFFECT_PLAYING:
          *UsageText = "Effect Playing";
          break;
        case HID_USAGE_PID_PID_DEVICE_CONTROL_REPORT:
          *UsageText = "PID Device Control Report";
          break;
        case HID_USAGE_PID_PID_DEVICE_CONTROL:
          *UsageText = "PID Device Control";
          break;
        case HID_USAGE_PID_DC_ENABLE_ACTUATORS:
          *UsageText = "Device Control Enable Actuators";
          break;
        case HID_USAGE_PID_DC_DISABLE_ACTUATORS:
          *UsageText = "Device Control Disable Actuators";
          break;
        case HID_USAGE_PID_DC_STOP_ALL_EFFECTS:
          *UsageText = "Device Control Stop All Effects";
          break;
        case HID_USAGE_PID_DC_DEVICE_RESET:
          *UsageText = "Device Control Device Reset";
          break;
        case HID_USAGE_PID_DC_DEVICE_PAUSE:
          *UsageText = "Device Control Device Pause";
          break;
        case HID_USAGE_PID_DC_DEVICE_CONTINUE:
          *UsageText = "Device Control Device Continue";
          break;
        case HID_USAGE_PID_DEVICE_PAUSED:
          *UsageText = "Device Paused";
          break;
        case HID_USAGE_PID_ACTUATORS_ENABLED:
          *UsageText = "Actuators Enabled";
          break;
        case HID_USAGE_PID_SAFETY_SWITCH:
          *UsageText = "Safety Switch";
          break;
        case HID_USAGE_PID_ACTUATOR_OVERRIDE_SWITCH:
          *UsageText = "Actuator Override Switch";
          break;
        case HID_USAGE_PID_ACTUATOR_POWER:
          *UsageText = "Actuator Power";
          break;
        case HID_USAGE_PID_START_DELAY:
          *UsageText = "Start Delay";
          break;
        case HID_USAGE_PID_PARAMETER_BLOCK_SIZE:
          *UsageText = "Parameter Block Size";
          break;
        case HID_USAGE_PID_DEVICE_MANAGED_POOL:
          *UsageText = "Device Managed Pool";
          break;
        case HID_USAGE_PID_SHARED_PARAMETER_BLOCKS:
          *UsageText = "Shared Parameter Blocks";
          break;
        case HID_USAGE_PID_CREATE_NEW_EFFECT_REPORT:
          *UsageText = "Create New Effect Report";
          break;
        case HID_USAGE_PID_RAM_POOL_AVAILABLE:
          *UsageText = "RAM Pool Available";
          break;
      }
      break;
    case HID_USAGE_PAGE_UNICODE:
      *UsagePageText = "Unicode";
      break;
    case HID_USAGE_PAGE_ALPHANUMERIC:
      *UsagePageText = "Alphanumeric";
      switch(Usage)
      {
        case HID_USAGE_ALNUM_DISPLAY_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ALPHANUMERIC_DISPLAY:
          *UsageText = "Alphanumeric Display";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_ATTRIBUTES_REPORT:
          *UsageText = "Display Attributes Report";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ASCII_CHARSET:
          *UsageText = "ASCII Character Set";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DATA_READ_BACK:
          *UsageText = "Data Read Back";
          break;
        case HID_USAGE_ALNUM_DISPLAY_FONT_READ_BACK:
          *UsageText = "Font Read Back";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_CONTROL_REPORT:
          *UsageText = "Display Control Report";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CLEAR_DISPLAY:
          *UsageText = "Clear Display";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_ENABLE:
          *UsageText = "Display Enable";
          break;
        case HID_USAGE_ALNUM_DISPLAY_SCREEN_SAVER_DELAY:
          *UsageText = "Screen Saver Delay";
          break;
        case HID_USAGE_ALNUM_DISPLAY_SCREEN_SAVER_ENABLE:
          *UsageText = "Screen Saver Enable";
          break;
        case HID_USAGE_ALNUM_DISPLAY_VERTICAL_SCROLL:
          *UsageText = "Vertical Scroll";
          break;
        case HID_USAGE_ALNUM_DISPLAY_HORIZONTAL_SCROLL:
          *UsageText = "Horizontal Scroll";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHARACTER_REPORT:
          *UsageText = "Character Report";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_DATA:
          *UsageText = "Display Data";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_STATUS:
          *UsageText = "Display Status";
          break;
        case HID_USAGE_ALNUM_DISPLAY_STAT_NOT_READY:
          *UsageText = "Stat Not Ready";
          break;
        case HID_USAGE_ALNUM_DISPLAY_STAT_READY:
          *UsageText = "Stat Ready";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ERR_NOT_A_LOADABLE_CHAR:
          *UsageText = "Error Not a Loadable Char";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ERR_FONT_DATA_CANNOT_BE_READ:
          *UsageText = "Error Font Data Cannot Be Read";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CURSOR_POSITION_REPORT:
          *UsageText = "Cursor Position Report";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ROW:
          *UsageText = " Row";
          break;
        case HID_USAGE_ALNUM_DISPLAY_COLUMN:
          *UsageText = "Column";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ROWS:
          *UsageText = "Rows";
          break;
        case HID_USAGE_ALNUM_DISPLAY_COLUMNS:
          *UsageText = "Columns";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CURSOR_PIXEL_POSITIONING:
          *UsageText = "Cursor Pixel Positioning";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CURSOR_MODE:
          *UsageText = "Cursor Mode";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CURSOR_ENABLE:
          *UsageText = "Cursor Enable";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CURSOR_BLINK:
          *UsageText = "Cursor Blink";
          break;
        case HID_USAGE_ALNUM_DISPLAY_FONT_REPORT:
          *UsageText = "Font Report";
          break;
        case HID_USAGE_ALNUM_DISPLAY_FONT_DATA:
          *UsageText = "Font Data";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_WIDTH:
          *UsageText = "Character Width";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_HEIGHT:
          *UsageText = "Character Height";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_SPACING_HORIZONTAL:
          *UsageText = "Character Spacing Horizontal";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_SPACING_VERTICAL:
          *UsageText = "Character Spacing Vertical";
          break;
        case HID_USAGE_ALNUM_DISPLAY_UNICODE_CHARSET:
          *UsageText = "Unicode Character Set";
          break;
        case HID_USAGE_ALNUM_DISPLAY_FONT_7_SEGMENT:
          *UsageText = "Font 7 Segment";
          break;
        case HID_USAGE_ALNUM_DISPLAY_7_SEGMENT_DIRECT_MAP:
          *UsageText = "7 Segment Direct Map";
          break;
        case HID_USAGE_ALNUM_DISPLAY_FONT_14_SEGMENT:
          *UsageText = "Font 14 Segment";
          break;
        case HID_USAGE_ALNUM_DISPLAY_14_SEGMENT_DIRECT_MAP:
          *UsageText = "14 Segment Direct Map";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_BRIGHTNESS:
          *UsageText = "Display Brightness";
          break;
        case HID_USAGE_ALNUM_DISPLAY_DISPLAY_CONTRAST:
          *UsageText = "Display Contrast";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_ATTRIBUTE:
          *UsageText = "Character Attribute";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ATTRIBUTE_READBACK:
          *UsageText = "Attribute Read Back";
          break;
        case HID_USAGE_ALNUM_DISPLAY_ATTRIBUTE_DATA:
          *UsageText = "Attribute Data";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_ATTR_ENHANCE:
          *UsageText = "Character Attribute Enhance";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_ATTR_UNDERLINE:
          *UsageText = "Character Attribute Underline";
          break;
        case HID_USAGE_ALNUM_DISPLAY_CHAR_ATTR_BLINK:
          *UsageText = "Character Attribute Blink";
          break;
      }
      break;
    case HID_USAGE_PAGE_MEDICAL_INSTRUMENT:
      *UsagePageText = "Medical Instrument";
      switch(Usage)
      {
        case HID_USAGE_MEDICAL_INSTRUMENT_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_MEDICAL_ULTRASOUND:
          *UsageText = "Medical Ultrasound";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_VCR_AQUISITION:
          *UsageText = "VCR Aquisition";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_FREEZE_THAW:
          *UsageText = "Freeze/Thaw";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_CLIP_STORE:
          *UsageText = "Clip Store";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_UPDATE:
          *UsageText = "Update";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_NEXT:
          *UsageText = "Next";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SAVE:
          *UsageText = "Save";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_PRINT:
          *UsageText = "Print";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_MICROPHONE_ENABLE:
          *UsageText = "Microphone Enable";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_CINE:
          *UsageText = "Cine";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_TRANSMIT_POWER:
          *UsageText = "Transmit Power";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_VOLUME:
          *UsageText = "Volume";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_FOCUS:
          *UsageText = "Focus";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_DEPTH:
          *UsageText = "Depth";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SOFT_STEP_PRIMARY:
          *UsageText = "Soft Step Primary";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SOFT_STEP_SECONDARY:
          *UsageText = "Soft Step Secondary";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_DEPTH_GAIN_COMPENSATION:
          *UsageText = "Depth Gain Compensation";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_ZOOM_SELECT:
          *UsageText = "Zoom Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_ZOOM_ADJUST:
          *UsageText = "Zoom Adjust";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SPECTRAL_DOPPLER_MODE_SELECT:
          *UsageText = "Spectral Doppler Mode Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SPECTRAL_DOPPLER_ADJUST:
          *UsageText = "Spectral Doppler Adjust";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_COLOR_DOPPLER_MODE_SELECT:
          *UsageText = "Color Doppler Mode Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_COLOR_DOPPLER_ADJUST:
          *UsageText = "Color Doppler Adjust";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_MOTION_MODE_SELECT:
          *UsageText = "Motion Mode Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_MOTION_MODE_ADJUST:
          *UsageText = "Motion Mode Adjust";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_2D_MODE_SELECT:
          *UsageText = "2D Mode Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_2D_MODE_ADJUST:
          *UsageText = "2D Mode Adjust";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SOFT_CONTROL_SELECT:
          *UsageText = "Soft Control Select";
          break;
        case HID_USAGE_MEDICAL_INSTRUMENT_SOFT_CONTROL_ADJUST:
          *UsageText = "Soft Control Adjust";
          break;
      }
      break;
    case HID_USAGE_PAGE_USB_MONITOR:
      *UsagePageText = "USB Monitor";
      switch(Usage)
      {
        case HID_USAGE_MONITOR_RESERVED:
          *UsageText = "Reserved";
          break;
        case HID_USAGE_MONITOR_MONITOR_CONTROL:
          *UsageText = "Monitor Control";
          break;
        case HID_USAGE_MONITOR_EDID_INFORMATION:
          *UsageText = "EDID Information";
          break;
        case HID_USAGE_MONITOR_VDIF_INFORMATION:
          *UsageText = "VDIF Information";
          break;
        case HID_USAGE_MONITOR_VESA_VERSION:
          *UsageText = "VESA Version";
          break;
      }
      break;
    case HID_USAGE_PAGE_MONITOR_ENUMERATED_VALUES:
      *UsagePageText = "USB Enumerated Values";
      switch(Usage)
      {
        case HID_USAGE_MONITOR_ENUM_VALUE_NO_VALUE:
          *UsageText = "No Enumerated Value Selected";
          break;
      }
      break;
    case HID_USAGE_PAGE_VESA_VIRTUAL_CONTROLS:
      *UsagePageText = "VESA Virtual Controls";
      break;
    case HID_USAGE_PAGE_RESERVED:
      *UsagePageText = "Reserved";
      break;
    case HID_USAGE_PAGE_POWER_DEVICE:
      *UsagePageText = "Power Device";
      switch(Usage)
      {
        case HID_USAGE_POWER_DEVICE_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_POWER_DEVICE_INAME:
          *UsageText = "iName";
          break;
        case HID_USAGE_POWER_DEVICE_PRESENT_STATUS:
          *UsageText = "Present Status";
          break;
        case HID_USAGE_POWER_DEVICE_CHANGED_STATUS:
          *UsageText = "Changed Status";
          break;
        case HID_USAGE_POWER_DEVICE_UPS:
          *UsageText = "UPS";
          break;
        case HID_USAGE_POWER_DEVICE_POWER_SUPPLY:
          *UsageText = "Power Supply";
          break;
        case HID_USAGE_POWER_DEVICE_BATTERY_SYSTEM:
          *UsageText = "Battery System";
          break;
        case HID_USAGE_POWER_DEVICE_BATTERY_SYSTEM_ID:
          *UsageText = "Battery System ID";
          break;
        case HID_USAGE_POWER_DEVICE_BATTERY:
          *UsageText = "Battery";
          break;
        case HID_USAGE_POWER_DEVICE_BATTERY_ID:
          *UsageText = "Battery ID";
          break;
        case HID_USAGE_POWER_DEVICE_CHARGER:
          *UsageText = "Charger";
          break;
        case HID_USAGE_POWER_DEVICE_CHARGER_ID:
          *UsageText = "Charger ID";
          break;
        case HID_USAGE_POWER_DEVICE_POWER_CONVERTER:
          *UsageText = "Power Converter";
          break;
        case HID_USAGE_POWER_DEVICE_POWER_CONVERTER_ID:
          *UsageText = "Power Converter ID";
          break;
        case HID_USAGE_POWER_DEVICE_OUTLET_SYSTEM:
          *UsageText = "Outlet System";
          break;
        case HID_USAGE_POWER_DEVICE_OUTLET_SYSTEM_ID:
          *UsageText = "Outlet System ID";
          break;
        case HID_USAGE_POWER_DEVICE_INPUT:
          *UsageText = "Input";
          break;
        case HID_USAGE_POWER_DEVICE_INPUT_ID:
          *UsageText = "Input ID";
          break;
        case HID_USAGE_POWER_DEVICE_OUTPUT:
          *UsageText = "Output";
          break;
        case HID_USAGE_POWER_DEVICE_OUTPUT_ID:
          *UsageText = "Output ID";
          break;
        case HID_USAGE_POWER_DEVICE_FLOW:
          *UsageText = "Flow";
          break;
        case HID_USAGE_POWER_DEVICE_FLOW_ID:
          *UsageText = "Flow ID";
          break;
        case HID_USAGE_POWER_DEVICE_OUTLET:
          *UsageText = "Outlet";
          break;
        case HID_USAGE_POWER_DEVICE_OUTLET_ID:
          *UsageText = "Outlet ID";
          break;
        case HID_USAGE_POWER_DEVICE_GANG:
          *UsageText = "Gang";
          break;
        case HID_USAGE_POWER_DEVICE_GANG_ID:
          *UsageText = "Gang ID";
          break;
        case HID_USAGE_POWER_DEVICE_POWER_SUMMARY:
          *UsageText = "Power Summary";
          break;
        case HID_USAGE_POWER_DEVICE_POWER_SUMMARY_ID:
          *UsageText = "Power Summary ID";
          break;
        case HID_USAGE_POWER_DEVICE_VOLTAGE:
          *UsageText = "Voltage";
          break;
        case HID_USAGE_POWER_DEVICE_CURRENT:
          *UsageText = "Current";
          break;
        case HID_USAGE_POWER_DEVICE_FREQUENCY:
          *UsageText = "Frequency";
          break;
        case HID_USAGE_POWER_DEVICE_APPARENT_POWER:
          *UsageText = "Apparent Power";
          break;
        case HID_USAGE_POWER_DEVICE_ACTIVE_POWER:
          *UsageText = "Active Power";
          break;
        case HID_USAGE_POWER_DEVICE_PERCENT_LOAD:
          *UsageText = "Percent Load";
          break;
        case HID_USAGE_POWER_DEVICE_TEMPERATURE:
          *UsageText = "Temperature";
          break;
        case HID_USAGE_POWER_DEVICE_HUMIDITY:
          *UsageText = "Humidity";
          break;
        case HID_USAGE_POWER_DEVICE_BAD_COUNT:
          *UsageText = "Bad Count";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_VOLTAGE:
          *UsageText = "Config Voltage";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_CURRENT:
          *UsageText = "Config Current";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_FREQUENCY:
          *UsageText = "Config Frequency";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_APPARENT_POWER:
          *UsageText = "Config Apparent Power";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_ACTIVE_POWER:
          *UsageText = "Config Active Power";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_PERCENT_LOAD:
          *UsageText = "Config Percent Load";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_TEMPERATURE:
          *UsageText = "Config Temperature";
          break;
        case HID_USAGE_POWER_DEVICE_CONFIG_HUMIDITY:
          *UsageText = "Config Humidity";
          break;
        case HID_USAGE_POWER_DEVICE_SWITCH_ON_CONTROL:
          *UsageText = "Switch On Control";
          break;
        case HID_USAGE_POWER_DEVICE_SWITCH_OFF_CONTROL:
          *UsageText = "Switch Off Control";
          break;
        case HID_USAGE_POWER_DEVICE_TOGGLE_CONTROL:
          *UsageText = "Toggle Control";
          break;
        case HID_USAGE_POWER_DEVICE_LOW_VOLTAGE_TRANSFER:
          *UsageText = "Low Voltage Transfer";
          break;
        case HID_USAGE_POWER_DEVICE_HIGH_VOLTAGE_TRANSFER:
          *UsageText = "High Voltage Transfer";
          break;
        case HID_USAGE_POWER_DEVICE_DELAY_BEFORE_REBOOT:
          *UsageText = "Delay Before Reboot";
          break;
        case HID_USAGE_POWER_DEVICE_DELAY_BEFORE_STARTUP:
          *UsageText = "Delay Before Startup";
          break;
        case HID_USAGE_POWER_DEVICE_DELAY_BEFORE_SHUTDOWN:
          *UsageText = "Delay Before Shutdown";
          break;
        case HID_USAGE_POWER_DEVICE_TEST:
          *UsageText = "Test";
          break;
        case HID_USAGE_POWER_DEVICE_MODULE_RESET:
          *UsageText = "Module Reset";
          break;
        case HID_USAGE_POWER_DEVICE_AUDIBLE_ALARM_CONTROL:
          *UsageText = "Audible Alarm Control";
          break;
        case HID_USAGE_POWER_DEVICE_PRESENT:
          *UsageText = "Present";
          break;
        case HID_USAGE_POWER_DEVICE_GOOD:
          *UsageText = "Good";
          break;
        case HID_USAGE_POWER_DEVICE_INTERNAL_FAILURE:
          *UsageText = "Internal Failure";
          break;
        case HID_USAGE_POWER_DEVICE_VOLTAGE_OUT_OF_RANGE:
          *UsageText = "Voltage Out of Range";
          break;
        case HID_USAGE_POWER_DEVICE_FREQUENCY_OUT_OF_RANGE:
          *UsageText = "Frequency Out of Range";
          break;
        case HID_USAGE_POWER_DEVICE_OVERLOAD:
          *UsageText = "Overload";
          break;
        case HID_USAGE_POWER_DEVICE_OVERCHARGED:
          *UsageText = "Overcharged";
          break;
        case HID_USAGE_POWER_DEVICE_OVERTEMPERATURE:
          *UsageText = "Overtemperature";
          break;
        case HID_USAGE_POWER_DEVICE_SHUTDOWN_REQUESTED:
          *UsageText = "Shutdown Requested";
          break;
        case HID_USAGE_POWER_DEVICE_SHUTDOWN_IMMINENT:
          *UsageText = "Shutdown Imminent";
          break;
        case HID_USAGE_POWER_DEVICE_SWITCH_ON_OFF:
          *UsageText = "Switch On/Off";
          break;
        case HID_USAGE_POWER_DEVICE_SWITCHABLE:
          *UsageText = "Switchable";
          break;
        case HID_USAGE_POWER_DEVICE_USED:
          *UsageText = "Used";
          break;
        case HID_USAGE_POWER_DEVICE_BOOST:
          *UsageText = "Boost";
          break;
        case HID_USAGE_POWER_DEVICE_BUCK:
          *UsageText = "Buck";
          break;
        case HID_USAGE_POWER_DEVICE_INITIALIZED:
          *UsageText = "Initialized";
          break;
        case HID_USAGE_POWER_DEVICE_TESTED:
          *UsageText = "Tested";
          break;
        case HID_USAGE_POWER_DEVICE_AWAITING_POWER:
          *UsageText = "Awaiting Power";
          break;
        case HID_USAGE_POWER_DEVICE_COMMUNICATION_LOST:
          *UsageText = "Communication Lost";
          break;
        case HID_USAGE_POWER_DEVICE_IMANUFACTURER:
          *UsageText = "iManufacturer";
          break;
        case HID_USAGE_POWER_DEVICE_IPRODUCT:
          *UsageText = "iProduct";
          break;
        case HID_USAGE_POWER_DEVICE_ISERIALNUMBER:
          *UsageText = "iSerialNumber";
          break;
      }
      break;
    case HID_USAGE_PAGE_BATTERY_SYSTEM:
      *UsagePageText = "Battery System";
      switch(Usage)
      {
        case HID_USAGE_BATTERY_SYSTEM_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_BATTERY_MODE:
          *UsageText = "SMB Battery Mode";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_BATTERY_STATUS:
          *UsageText = "SMB Battery Status";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_ALARM_WARNING:
          *UsageText = "SMB Alarm Warning";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_CHARGER_MODE:
          *UsageText = "SMB Charger Mode";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_CHARGER_STATUS:
          *UsageText = "SMB Charger Status";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_CHARGER_SPEC_INFO:
          *UsageText = "SMB Charger Spec Info";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_SELECTOR_STATE:
          *UsageText = "SMB Selector state";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_SELECTOR_PRESETS:
          *UsageText = "SMB Selector Presets";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_SELECTOR_INFO:
          *UsageText = "SMB Selector Info";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OPTIONAL_MFG_FUNCTION_1:
          *UsageText = "Optional Manufacturer Function 1";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OPTIONAL_MFG_FUNCTION_2:
          *UsageText = "Optional Manufacturer Function 2";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OPTIONAL_MFG_FUNCTION_3:
          *UsageText = "Optional Manufacturer Function 3";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OPTIONAL_MFG_FUNCTION_4:
          *UsageText = "Optional Manufacturer Function 4";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OPTIONAL_MFG_FUNCTION_5:
          *UsageText = "Optional Manufacturer Function 5";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CONNECTION_TO_SMBUS:
          *UsageText = "Connection to SMBus";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OUTPUT_CONNECTION:
          *UsageText = "Output Connection";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGER_CONNECTION:
          *UsageText = "Charger Connection";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BATTERY_INSERTION:
          *UsageText = "Battery Insertion";
          break;
        case HID_USAGE_BATTERY_SYSTEM_USE_NEXT:
          *UsageText = "Use Next";
          break;
        case HID_USAGE_BATTERY_SYSTEM_OK_TO_USE:
          *UsageText = "OK to Use";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BATTERY_SUPPORTED:
          *UsageText = "Battery Supported";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SELECTOR_REVISION:
          *UsageText = "Selector Revision";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGING_INDICATOR:
          *UsageText = "Charging Indicator";
          break;
        case HID_USAGE_BATTERY_SYSTEM_MANUFACTURER_ACCESS:
          *UsageText = "Manufacturer Access";
          break;
        case HID_USAGE_BATTERY_SYSTEM_REMAINING_CAPACITY_LIMIT:
          *UsageText = "Remaining Capacity Limit";
          break;
        case HID_USAGE_BATTERY_SYSTEM_REMAINING_TIME_LIMIT:
          *UsageText = "Remaining Time Limit";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AT_RATE:
          *UsageText = "At Rate";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CAPACITY_MODE:
          *UsageText = "Capacity Mode";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BROADCAST_TO_CHARGER:
          *UsageText = "Broadcast to Charger";
          break;
        case HID_USAGE_BATTERY_SYSTEM_PRIMARY_BATTERY:
          *UsageText = "Primary Battery";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGE_CONTROLLER:
          *UsageText = "Charge Controller";
          break;
        case HID_USAGE_BATTERY_SYSTEM_TERMINATE_CHARGE:
          *UsageText = "Terminate Charge";
          break;
        case HID_USAGE_BATTERY_SYSTEM_TERMINATE_DISCHARGE:
          *UsageText = "Terminate Discharge";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BELOW_REMAINING_CAPACITY_LIMIT:
          *UsageText = "Below Remaining Capacity";
          break;
        case HID_USAGE_BATTERY_SYSTEM_REMAINING_TIME_LIMIT_EXPIRED:
          *UsageText = "Remaining Time Limit Expired";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGING:
          *UsageText = "Charging";
          break;
        case HID_USAGE_BATTERY_SYSTEM_DISCHARGING:
          *UsageText = "Discharging";
          break;
        case HID_USAGE_BATTERY_SYSTEM_FULLY_CHARGED:
          *UsageText = "Fully Charged";
          break;
        case HID_USAGE_BATTERY_SYSTEM_FULLY_DISCHARGED:
          *UsageText = "Fully Discharged";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CONDITIONING_FLAG:
          *UsageText = "Conditioning Flag";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AT_RATE_OK:
          *UsageText = "At Rate OK";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SMB_ERROR_CODE:
          *UsageText = "SMB Error Code";
          break;
        case HID_USAGE_BATTERY_SYSTEM_NEED_REPLACEMENT:
          *UsageText = "Need Replacement";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AT_RATE_TIME_TO_FULL:
          *UsageText = "At Rate Time to Full";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AT_RATE_TIME_TO_EMPTY:
          *UsageText = "At Rate Time to Empty";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AVERAGE_CURRENT:
          *UsageText = "Average Current";
          break;
        case HID_USAGE_BATTERY_SYSTEM_MAX_ERROR:
          *UsageText = "Max Error";
          break;
        case HID_USAGE_BATTERY_SYSTEM_RELATIVE_STATE_OF_CHARGE:
          *UsageText = "Relative State of Charge";
          break;
        case HID_USAGE_BATTERY_SYSTEM_ABSOLUTE_STATE_OF_CHARGE:
          *UsageText = "absolute State of charge";
          break;
        case HID_USAGE_BATTERY_SYSTEM_REMAINING_CAPACITY:
          *UsageText = "Remaining Capacity";
          break;
        case HID_USAGE_BATTERY_SYSTEM_FULL_CHARGE_CAPACITY:
          *UsageText = "Full Charge Capacity";
          break;
        case HID_USAGE_BATTERY_SYSTEM_RUN_TIME_TO_EMPTY:
          *UsageText = "Run Time to Empty";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AVERAGE_TIME_TO_EMPTY:
          *UsageText = "Average Time to Empty";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AVERAGE_TIME_TO_FULL:
          *UsageText = "Average Time to Full";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CYCLE_COUNT:
          *UsageText = "Cycle Count";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BATT_PACK_MODEL_LEVEL:
          *UsageText = "Battery Pack Model Level";
          break;
        case HID_USAGE_BATTERY_SYSTEM_INTERNAL_CHARGE_CONTROLLER:
          *UsageText = "Internal Charge Controller";
          break;
        case HID_USAGE_BATTERY_SYSTEM_PRIMARY_BATTERY_SUPPORT:
          *UsageText = "Primary Battery Support";
          break;
        case HID_USAGE_BATTERY_SYSTEM_DESIGN_CAPACITY:
          *UsageText = "Design capacity";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SPECIFICATION_INFO:
          *UsageText = "Specification Info";
          break;
        case HID_USAGE_BATTERY_SYSTEM_MANUFACTURER_DATE:
          *UsageText = "Manufacturer Date";
          break;
        case HID_USAGE_BATTERY_SYSTEM_SERIAL_NUMBER:
          *UsageText = "Serial Number";
          break;
        case HID_USAGE_BATTERY_SYSTEM_I_MANUFACTURER_NAME:
          *UsageText = "iManufacturerName";
          break;
        case HID_USAGE_BATTERY_SYSTEM_I_DEVICE_NAME:
          *UsageText = "iDeviceName";
          break;
        case HID_USAGE_BATTERY_SYSTEM_I_DEVICE_CHEMISTERY:
          *UsageText = "iDeviceChemistery";
          break;
        case HID_USAGE_BATTERY_SYSTEM_MANUFACTURER_DATA:
          *UsageText = "Manufacturer Data";
          break;
        case HID_USAGE_BATTERY_SYSTEM_RECHARGABLE:
          *UsageText = "Rechargable";
          break;
        case HID_USAGE_BATTERY_SYSTEM_WARNING_CAPACITY_LIMIT:
          *UsageText = "Warning Capacity Limit";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CAPACITY_GRANULARITY_1:
          *UsageText = "Capacity Granularity 1";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CAPACITY_GRANULARITY_2:
          *UsageText = "Capacity Granularity 2";
          break;
        case HID_USAGE_BATTERY_SYSTEM_I_OEM_INFORMATION:
          *UsageText = "iOEMInformation";
          break;
        case HID_USAGE_BATTERY_SYSTEM_INHIBIT_CHARGE:
          *UsageText = "Inhibit Charge";
          break;
        case HID_USAGE_BATTERY_SYSTEM_ENABLE_POLLING:
          *UsageText = "Enable Polling";
          break;
        case HID_USAGE_BATTERY_SYSTEM_RESET_TO_ZERO:
          *UsageText = "Reset to zero";
          break;
        case HID_USAGE_BATTERY_SYSTEM_AC_PRESENT:
          *UsageText = "AC Present";
          break;
        case HID_USAGE_BATTERY_SYSTEM_BATTERY_PRESENT:
          *UsageText = "Battery Present";
          break;
        case HID_USAGE_BATTERY_SYSTEM_POWER_FAIL:
          *UsageText = "Power Fail";
          break;
        case HID_USAGE_BATTERY_SYSTEM_ALARM_INHIBITED:
          *UsageText = "Alarm Inhibited";
          break;
        case HID_USAGE_BATTERY_SYSTEM_THERMISTOR_UNDER_RANGE:
          *UsageText = "Thermistor Under range";
          break;
        case HID_USAGE_BATTERY_SYSTEM_THERMISTOR_HOT:
          *UsageText = "Thermistor Hot";
          break;
        case HID_USAGE_BATTERY_SYSTEM_THERMISTOR_COLD:
          *UsageText = "Thermistor Cold";
          break;
        case HID_USAGE_BATTERY_SYSTEM_THERMISTOR_OVER_RANGE:
          *UsageText = "Thermistor Over Range";
          break;
        case HID_USAGE_BATTERY_SYSTEM_VOLTAGE_OUT_OF_RANGE:
          *UsageText = "Voltage out of Range";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CURRENT_OUT_OF_RANGE:
          *UsageText = "Current Out of Range";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CURRENT_NOT_REGULATED:
          *UsageText = "Current Not Regulated";
          break;
        case HID_USAGE_BATTERY_SYSTEM_VOLTAGE_NOT_REGULATED:
          *UsageText = "Voltage Not Regulated";
          break;
        case HID_USAGE_BATTERY_SYSTEM_MASTER_MODE:
          *UsageText = "Master Mode";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGER_SELECTOR_SUPPORT:
          *UsageText = "Charger Selector Support";
          break;
        case HID_USAGE_BATTERY_SYSTEM_CHARGER_SPEC:
          *UsageText = "Charger Spec";
          break;
        case HID_USAGE_BATTERY_SYSTEM_LEVEL_2:
          *UsageText = "Level 2";
          break;
        case HID_USAGE_BATTERY_SYSTEM_LEVEL_3:
          *UsageText = "Level 3";
          break;
      }
      break;
    case HID_USAGE_PAGE_BARCODE_SCANNER:
      *UsagePageText = "Barcode Scanner";
      switch(Usage)
      {
        case HID_USAGE_BARCODE_SCANNER_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_CODE_BADGE_READER:
          *UsageText = "Bar Code Badge Reader";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_CODE_SCANNER:
          *UsageText = "Bar Code Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_DUMB_BAR_CODE_SCANNER:
          *UsageText = "Dumb Bar Code Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_CORDLESS_SCANNER_BASE:
          *UsageText = "Cordless Scanner Base";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_CODE_SCANNER_CRADLE:
          *UsageText = "Bar Code Scanner Cradle";
          break;
        case HID_USAGE_BARCODE_SCANNER_ATTRIBUTE_REPORT:
          *UsageText = "Attribute Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_SETTINGS_REPORT:
          *UsageText = "Settings Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_SCANNED_DATA_REPORT:
          *UsageText = "Scanned Data Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_RAW_SCANNED_DATA_REPORT:
          *UsageText = "Raw Scanned Data Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRIGGER_REPORT:
          *UsageText = "Trigger Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_STATUS_REPORT:
          *UsageText = "Status Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_EAN_CONTROL_REPORT:
          *UsageText = "UPC/EAN Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_2_3_LABEL_CONTROL_REPORT:
          *UsageText = "EAN 2/3 Label Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_39_CONTROL_REPORT:
          *UsageText = "Code 39 Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_INTERLEAVED_2_OF_5_CONTROL_REPORT:
          *UsageText = "Interleaved 2 of 5 Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_STANDARD_2_OF_5_CONTROL_REPORT:
          *UsageText = "Standard 2 of 5 Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_MSI_PLESSEY_CONTROL_REPORT:
          *UsageText = "MSI Plessey Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODABAR_CONTROL_REPORT:
          *UsageText = "Codabar Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_128_CONTROL_REPORT:
          *UsageText = "Code 128 Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_MISC_1D_CONTROL_REPORT:
          *UsageText = "Misc 1D Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_2D_CONTROL_REPORT:
          *UsageText = "2D Control Report";
          break;
        case HID_USAGE_BARCODE_SCANNER_AIMING_POINTER_MODE:
          *UsageText = "Aiming/Pointer Mode";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_CODE_PRESENT_SENSOR:
          *UsageText = "Bar Code Present Sensor";
          break;
        case HID_USAGE_BARCODE_SCANNER_CLASS_1A_LASER:
          *UsageText = "Class 1A Laser";
          break;
        case HID_USAGE_BARCODE_SCANNER_CLASS_2_LASER:
          *UsageText = "Class 2 Laser";
          break;
        case HID_USAGE_BARCODE_SCANNER_HEATER_PRESENT:
          *UsageText = "Heater Present";
          break;
        case HID_USAGE_BARCODE_SCANNER_CONTACT_SCANNER:
          *UsageText = "Contact Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_ELECTRONIC_ARTICLE_SURVEILLANCE_NOTIFICATION:
          *UsageText = "Electronic Article Surveillance Notification";
          break;
        case HID_USAGE_BARCODE_SCANNER_CONSTANT_ARTICLE_SURVEILLANCE_NOTIFICATION:
          *UsageText = "Constant Article Surveillance Notification";
          break;
        case HID_USAGE_BARCODE_SCANNER_ERROR_INDICATION:
          *UsageText = "Error Indication";
          break;
        case HID_USAGE_BARCODE_SCANNER_FIXED_BEEPER:
          *UsageText = "Fixed Beeper";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_DECODE_INDICATION:
          *UsageText = "Good Decode Indication";
          break;
        case HID_USAGE_BARCODE_SCANNER_HANDS_FREE_SCANNING:
          *UsageText = "Hands Free Scanning";
          break;
        case HID_USAGE_BARCODE_SCANNER_INTRINSICALLY_SAFE:
          *UsageText = "Intrinsically Safe";
          break;
        case HID_USAGE_BARCODE_SCANNER_KLASSE_EINS_LASER:
          *UsageText = "Klasse Eins Laser (Class 1 Laser)";
          break;
        case HID_USAGE_BARCODE_SCANNER_LONG_RANGE_SCANNER:
          *UsageText = "Long Range Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_MIRROR_SPEED_CONTROL:
          *UsageText = "Mirror Speed Control";
          break;
        case HID_USAGE_BARCODE_SCANNER_NOT_ON_FILE_INDICATION:
          *UsageText = "Not On File Indication";
          break;
        case HID_USAGE_BARCODE_SCANNER_PROGRAMMABLE_BEEPER:
          *UsageText = "Programmable Beeper";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRIGGERLESS:
          *UsageText = "Triggerless";
          break;
        case HID_USAGE_BARCODE_SCANNER_WAND:
          *UsageText = "Wand";
          break;
        case HID_USAGE_BARCODE_SCANNER_WATER_RESISTANT:
          *UsageText = "Water Resistant";
          break;
        case HID_USAGE_BARCODE_SCANNER_MULTI_RANGE_SCANNER:
          *UsageText = "Multi-Range Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_PROXIMITIY_SENSOR:
          *UsageText = "Proximity Sensor";
          break;
        case HID_USAGE_BARCODE_SCANNER_FRAGMENT_DECODING:
          *UsageText = "Fragment Decoding";
          break;
        case HID_USAGE_BARCODE_SCANNER_SCANNER_READ_CONFIDENCE:
          *UsageText = "Scanner Read Confidence";
          break;
        case HID_USAGE_BARCODE_SCANNER_DATA_PREFIX:
          *UsageText = "Data Prefix";
          break;
        case HID_USAGE_BARCODE_SCANNER_PREFIX_AIMI:
          *UsageText = "Prefix AIMI";
          break;
        case HID_USAGE_BARCODE_SCANNER_PREFIX_NODE:
          *UsageText = "Prefix Node";
          break;
        case HID_USAGE_BARCODE_SCANNER_PREFIX_PROPRIETARY:
          *UsageText = "Prefix Proprietary";
          break;
        case HID_USAGE_BARCODE_SCANNER_ACTIVE_TIME:
          *UsageText = "Active Time";
          break;
        case HID_USAGE_BARCODE_SCANNER_AIMING_LASER_PATTERN:
          *UsageText = "Aiming Laser Pattern";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_CODE_PRESENT:
          *UsageText = "Bar Code Present";
          break;
        case HID_USAGE_BARCODE_SCANNER_BEEPER_STATE:
          *UsageText = "Beeper State";
          break;
        case HID_USAGE_BARCODE_SCANNER_LASER_ON_TIME:
          *UsageText = "Laser On Time";
          break;
        case HID_USAGE_BARCODE_SCANNER_LASER_STATE:
          *UsageText = "Laser State";
          break;
        case HID_USAGE_BARCODE_SCANNER_LOCKOUT_TIME:
          *UsageText = "Lockout Time";
          break;
        case HID_USAGE_BARCODE_SCANNER_MOTOR_STATE:
          *UsageText = "Motor State";
          break;
        case HID_USAGE_BARCODE_SCANNER_MOTOR_TIMEOUT:
          *UsageText = "Motor Timeout";
          break;
        case HID_USAGE_BARCODE_SCANNER_POWER_ON_RESET_SCANNER:
          *UsageText = "Power On Reset Scanner";
          break;
        case HID_USAGE_BARCODE_SCANNER_PREVENT_READ_OF_BARCODES:
          *UsageText = "Prevent Read of Barcodes";
          break;
        case HID_USAGE_BARCODE_SCANNER_INITIATE_BARCODE_READ:
          *UsageText = "Initiate Barcode Read";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRIGGER_STATE:
          *UsageText = "Trigger State";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRIGGER_MODE:
          *UsageText = "Trigger Mode";
          break;
        case HID_USAGE_BARCODE_SCANNER_TM_BLINKING_LASER_ON:
          *UsageText = "Trigger Mode Blinking Laser On";
          break;
        case HID_USAGE_BARCODE_SCANNER_TM_CONTINUOUS_LASER_ON:
          *UsageText = "Trigger Mode Continuous Laser On";
          break;
        case HID_USAGE_BARCODE_SCANNER_TM_LASER_ON_WHILE_PULLED:
          *UsageText = "Trigger Mode Laser On While Pulled";
          break;
        case HID_USAGE_BARCODE_SCANNER_TM_LASER_STAYS_ON_AFTER_TRIGGER_RELEASE:
          *UsageText = "Trigger Mode Laser Stays On After Trigger Release";
          break;
        case HID_USAGE_BARCODE_SCANNER_COMMIT_PARAMETERS_TO_NVM:
          *UsageText = "Commit Parameters to NVM";
          break;
        case HID_USAGE_BARCODE_SCANNER_PARAMETER_SCANNING:
          *UsageText = "Parameter Scanning";
          break;
        case HID_USAGE_BARCODE_SCANNER_PARAMETERS_CHANGED:
          *UsageText = "Parameters Changed";
          break;
        case HID_USAGE_BARCODE_SCANNER_SET_PARAMETER_DEFAULT_VALUES:
          *UsageText = "Set Parameter Default Values";
          break;
        case HID_USAGE_BARCODE_SCANNER_SCANNER_IN_CRADLE:
          *UsageText = "Scanner in Cradle";
          break;
        case HID_USAGE_BARCODE_SCANNER_SCANNER_IN_RANGE:
          *UsageText = "Scanner in Range";
          break;
        case HID_USAGE_BARCODE_SCANNER_AIM_DURATION:
          *UsageText = "Aim Duration";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_LAMP_DURATION:
          *UsageText = "Good Read Lamp Duration";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_LAMP_INTENSITY:
          *UsageText = "Good Read Lamp Intensity";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_LED:
          *UsageText = "Good Read LED";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_TONE_FREQUENCY:
          *UsageText = "Good Read Tone Frequency";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_TONE_LENGTH:
          *UsageText = "Good Read Tone Length";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_TONE_VOLUME:
          *UsageText = "Good Read Tone Volume";
          break;
        case HID_USAGE_BARCODE_SCANNER_NO_READ_MESSAGE:
          *UsageText = "No Read Message";
          break;
        case HID_USAGE_BARCODE_SCANNER_NOT_ON_FILE_VOLUME:
          *UsageText = "Not On File Volume";
          break;
        case HID_USAGE_BARCODE_SCANNER_POWERUP_BEEP:
          *UsageText = "Powerup Beep";
          break;
        case HID_USAGE_BARCODE_SCANNER_SOUND_ERROR_BEEP:
          *UsageText = "Sound Error Beep";
          break;
        case HID_USAGE_BARCODE_SCANNER_SOUND_GOOD_READ_BEEP:
          *UsageText = "Sound Good Read Beep";
          break;
        case HID_USAGE_BARCODE_SCANNER_SOUND_NOT_ON_FILE_BEEP:
          *UsageText = "Sound Not On File Beep";
          break;
        case HID_USAGE_BARCODE_SCANNER_GOOD_READ_WHEN_TO_WRITE:
          *UsageText = "Good Read When to Write";
          break;
        case HID_USAGE_BARCODE_SCANNER_GRWTI_AFTER_DECODE:
          *UsageText = "GRWTI After Decode";
          break;
        case HID_USAGE_BARCODE_SCANNER_GRWTI_BEEP_LAMP_AFTER_TRANSMIT:
          *UsageText = "GRWTI Beep/Lamp After Transmit";
          break;
        case HID_USAGE_BARCODE_SCANNER_GRWTI_NO_BEEP_LAMP_USE_AT_ALL:
          *UsageText = "GRWTI No Beep/Lamp Use at All";
          break;
        case HID_USAGE_BARCODE_SCANNER_BOOKLAND_EAN:
          *UsageText = "Bookland EAN";
          break;
        case HID_USAGE_BARCODE_SCANNER_CONVERT_EAN_8_TO_13_TYPE:
          *UsageText = "Convert EAN 8 to 13 Type";
          break;
        case HID_USAGE_BARCODE_SCANNER_CONVERT_UPC_A_TO_EAN_13:
          *UsageText = "Convert UPC A to EAN-13";
          break;
        case HID_USAGE_BARCODE_SCANNER_CONVERT_UPC_E_TO_A:
          *UsageText = "Convert UPC-E to A";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_13:
          *UsageText = "EAN-13";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_8:
          *UsageText = "EAN-8";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_99_128_MANDATORY:
          *UsageText = "EAN-99 128 Mandatory";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_99_P5_128_OPTIONAL:
          *UsageText = "EAN-99 P5/128 Optional";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_EAN:
          *UsageText = "UPC/EAN";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_EAN_COUPON_CODE:
          *UsageText = "UPC/EAN Coupon Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_EAN_PERIODICALS:
          *UsageText = "UPC/EAN Periodicals";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_A:
          *UsageText = "UPC-A";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_A_WITH_128_MANDATORY:
          *UsageText = "UPC-A with 128 Mandatory";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_A_WITH_128_OPTIONAL:
          *UsageText = "UPC-A with 128 Optional";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_A_WITH_P5_OPTIONAL:
          *UsageText = "UPC-A with P5 Optional";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_E:
          *UsageText = "UPC-E";
          break;
        case HID_USAGE_BARCODE_SCANNER_UPC_E1:
          *UsageText = "UPC-E1";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL:
          *UsageText = "Periodical";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_AUTODISCRIMINATE_2:
          *UsageText = "Periodical Auto-Discriminate +2";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_ONLY_DECODE_WITH_2:
          *UsageText = "Periodical Only Decode with +2";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_IGNORE_2:
          *UsageText = "Periodical Ignore +2";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_AUTODISCRIMINATE_5:
          *UsageText = "Periodical Auto-Discriminate +5";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_ONLY_DECODE_WITH_5:
          *UsageText = "Periodical Only Decode with +5";
          break;
        case HID_USAGE_BARCODE_SCANNER_PERIODICAL_IGNORE_5:
          *UsageText = "Periodical Ignore +5";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK:
          *UsageText = "Check";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_DISABLE_PRICE:
          *UsageText = "Check Disable Price";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_ENABLE_4_DIGIT_PRICE:
          *UsageText = "Check Enable 4 Digit Price";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_ENABLE_5_DIGIT_PRICE:
          *UsageText = "Check Enable 5 Digit Price";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_ENABLE_EUROPEAN_4_DIGIT_PRICE:
          *UsageText = "Check Enable European 4 Digit Price";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_ENABLE_EUROPEAN_5_DIGIT_PRICE:
          *UsageText = "Check Enable European 5 Digit Price";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_TWO_LABEL:
          *UsageText = "EAN Two Label";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_THREE_LABEL:
          *UsageText = "EAN Three Label";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_8_FLAG_DIGIT_1:
          *UsageText = "EAN 8 Flag Digit 1";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_8_FLAG_DIGIT_2:
          *UsageText = "EAN 8 Flag Digit 2";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_8_FLAG_DIGIT_3:
          *UsageText = "EAN 8 Flag Digit 3";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_13_FLAG_DIGIT_1:
          *UsageText = "EAN 13 Flag Digit 1";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_13_FLAG_DIGIT_2:
          *UsageText = "EAN 13 Flag Digit 2";
          break;
        case HID_USAGE_BARCODE_SCANNER_EAN_13_FLAG_DIGIT_3:
          *UsageText = "EAN 13 Flag Digit 3";
          break;
        case HID_USAGE_BARCODE_SCANNER_ADD_EAN_2_3_LABEL_DEFINITION:
          *UsageText = "Add EAN 2/3 Label Definition";
          break;
        case HID_USAGE_BARCODE_SCANNER_CLEAR_ALL_EAN_2_3_LABEL_DEFINITIONS:
          *UsageText = "Clear All EAN 2/3 Label Definitions";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODABAR:
          *UsageText = "Codabar";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_128:
          *UsageText = "Code 128";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_39:
          *UsageText = "Code 39";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_93:
          *UsageText = "Code 93";
          break;
        case HID_USAGE_BARCODE_SCANNER_FULL_ASCII_CONVERSION:
          *UsageText = "Full ASCII Conversion";
          break;
        case HID_USAGE_BARCODE_SCANNER_INTERLEAVED_2_OF_5:
          *UsageText = "Interleaved 2 of 5";
          break;
        case HID_USAGE_BARCODE_SCANNER_ITALIAN_PHARMACY_CODE:
          *UsageText = "Italian Pharmacy Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_MSI_PLESSEY:
          *UsageText = "MSI/Plessey";
          break;
        case HID_USAGE_BARCODE_SCANNER_STANDARD_2_OF_5_IATA:
          *UsageText = "Standard 2 of 5 IATA";
          break;
        case HID_USAGE_BARCODE_SCANNER_STANDARD_2_OF_5:
          *UsageText = "Standard 2 of 5";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRANSMIT_START_STOP:
          *UsageText = "Transmit Start/Stop";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRI_OPTIC:
          *UsageText = "Tri-Optic";
          break;
        case HID_USAGE_BARCODE_SCANNER_UCC_EAN_128:
          *UsageText = "UCC/EAN-128";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHECK_DIGIT:
          *UsageText = "Check Digit";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_DISABLE:
          *UsageText = "Check Digit Disable";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_INTERLEAVED_2_OF_5_OPCC:
          *UsageText = "Check Digit Enable Interleaved 2 of 5 OPCC";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_INTERLEAVED_2_OF_5_USS:
          *UsageText = "Check Digit Enable Interleaved 2 of 5 USS";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_STANDARD_2_OF_5_OPCC:
          *UsageText = "Check Digit Enable Standard 2 of 5 OPCC";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_STANDARD_2_OF_5_USS:
          *UsageText = "Check Digit Enable Standard 2 of 5 USS";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_ONE_MSI_PLESSEY:
          *UsageText = "Check Digit Enable One MSI/Plessey";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_ENABLE_TWO_MSI_PLESSEY:
          *UsageText = "Check Digit Enable Two MSI/Plessey";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_CODABAR_ENABLE:
          *UsageText = "Check Digit Codabar Enable";
          break;
        case HID_USAGE_BARCODE_SCANNER_CD_CODE_39_ENABLE:
          *UsageText = "Check Digit Code 39 Enable";
          break;
        case HID_USAGE_BARCODE_SCANNER_TRANSMIT_CHECK_DIGIT:
          *UsageText = "Transmit Check Digit";
          break;
        case HID_USAGE_BARCODE_SCANNER_DISABLE_CHECK_DIGIT_TRANSMIT:
          *UsageText = "Disable Check Digit Transmit";
          break;
        case HID_USAGE_BARCODE_SCANNER_ENABLE_CHECK_DIGIT_TRANSMIT:
          *UsageText = "Enable Check Digit Transmit";
          break;
        case HID_USAGE_BARCODE_SCANNER_SYMBOLOGY_IDENTIFIER_1:
          *UsageText = "Symbology Identifier 1";
          break;
        case HID_USAGE_BARCODE_SCANNER_SYMBOLOGY_IDENTIFIER_2:
          *UsageText = "Symbology Identifier 2";
          break;
        case HID_USAGE_BARCODE_SCANNER_SYMBOLOGY_IDENTIFIER_3:
          *UsageText = "Symbology Identifier 3";
          break;
        case HID_USAGE_BARCODE_SCANNER_DECODED_DATA:
          *UsageText = "Decode Data";
          break;
        case HID_USAGE_BARCODE_SCANNER_DECODED_DATA_CONTINUED:
          *UsageText = "Decoded Data Continued";
          break;
        case HID_USAGE_BARCODE_SCANNER_BAR_SPACE_DATA:
          *UsageText = "Bar Space Data";
          break;
        case HID_USAGE_BARCODE_SCANNER_SCANNER_DATA_ACCURACY:
          *UsageText = "Scanner Data Accuracy";
          break;
        case HID_USAGE_BARCODE_SCANNER_RAW_DATA_POLARITY:
          *UsageText = "Raw Data Polarity";
          break;
        case HID_USAGE_BARCODE_SCANNER_POLARITY_INVERTED_BAR_CODE:
          *UsageText = "Polarity Inverted Bar Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_POLARITY_NORMAL_BAR_CODE:
          *UsageText = "Polarity Normal Bar Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_MINIMUM_LENGTH_TO_DECODE:
          *UsageText = "Minimum Length to Decode";
          break;
        case HID_USAGE_BARCODE_SCANNER_MAXIMUM_LENGTH_TO_DECODE:
          *UsageText = "Maximum Length to Decode";
          break;
        case HID_USAGE_BARCODE_SCANNER_FIRST_DISCRETE_LENGTH_TO_DECODE:
          *UsageText = "First Discrete Length to Decode";
          break;
        case HID_USAGE_BARCODE_SCANNER_SECOND_DISCRETE_LENGTH_TO_DECODE:
          *UsageText = "Second Discrete Length to Decode";
          break;
        case HID_USAGE_BARCODE_SCANNER_DATA_LENGTH_METHOD:
          *UsageText = "Data Length Method";
          break;
        case HID_USAGE_BARCODE_SCANNER_DLM_READ_ANY:
          *UsageText = "Data Length Method Read Any";
          break;
        case HID_USAGE_BARCODE_SCANNER_DLM_CHECK_IN_RANGE:
          *UsageText = "Data Length Method Check in Range";
          break;
        case HID_USAGE_BARCODE_SCANNER_DLM_CHECK_FOR_DISCRETE:
          *UsageText = "Data Length Method Check for Discrete";
          break;
        case HID_USAGE_BARCODE_SCANNER_AZTEC_CODE:
          *UsageText = "Aztec Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_BC412:
          *UsageText = "BC412";
          break;
        case HID_USAGE_BARCODE_SCANNER_CHANNEL_CODE:
          *UsageText = "Channel Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_16:
          *UsageText = "Code 16";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_32:
          *UsageText = "Code 32";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_49:
          *UsageText = "Code 49";
          break;
        case HID_USAGE_BARCODE_SCANNER_CODE_ONE:
          *UsageText = "Code One";
          break;
        case HID_USAGE_BARCODE_SCANNER_COLORCODE:
          *UsageText = "Colorcode";
          break;
        case HID_USAGE_BARCODE_SCANNER_DATA_MATRIX:
          *UsageText = "Data Matrix";
          break;
        case HID_USAGE_BARCODE_SCANNER_MAXICODE:
          *UsageText = "MaxiCode";
          break;
        case HID_USAGE_BARCODE_SCANNER_MICROPDF:
          *UsageText = "MicroPDF";
          break;
        case HID_USAGE_BARCODE_SCANNER_PDF_417:
          *UsageText = "PDF-417";
          break;
        case HID_USAGE_BARCODE_SCANNER_POSICODE:
          *UsageText = "PosiCode";
          break;
        case HID_USAGE_BARCODE_SCANNER_QR_CODE:
          *UsageText = "QR Code";
          break;
        case HID_USAGE_BARCODE_SCANNER_SUPERCODE:
          *UsageText = "SuperCode";
          break;
        case HID_USAGE_BARCODE_SCANNER_ULTRACODE:
          *UsageText = "UltraCode";
          break;
        case HID_USAGE_BARCODE_SCANNER_USD_5:
          *UsageText = "USD-5 (Slug Code)";
          break;
        case HID_USAGE_BARCODE_SCANNER_VERICODE:
          *UsageText = "VeriCode";
          break;
      }
      break;
    case HID_USAGE_PAGE_WEIGHING_DEVICE:
      *UsagePageText = "Weighing Device";
      switch(Usage)
      {
        case HID_USAGE_SCALE_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_SCALE_WEIGHING_DEVICE:
          *UsageText = "Weighing Device";
          break;
        case HID_USAGE_SCALE_SCALE_DEVICE_CLASS:
          *UsageText = "Scale Device Class";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_I_METRIC_CLASS:
          *UsageText = "Scale Class I Metric Class";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_I_METRIC:
          *UsageText = "Scale Class I Metric";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_II_METRIC:
          *UsageText = "Scale Class II Metric";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_III_METRIC:
          *UsageText = "Scale Class III Metric";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_IIIL_METRIC:
          *UsageText = "Scale Class IIIL Metric";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_IV_METRIC:
          *UsageText = "Scale Class IV Metric";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_III_ENGLISH:
          *UsageText = "Scale Class III English";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_IIIL_ENGLISH:
          *UsageText = "Scale Class IIIL English";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_IV_ENGLISH:
          *UsageText = "Scale Class IV English";
          break;
        case HID_USAGE_SCALE_SCALE_CLASS_GENERIC:
          *UsageText = "Scale Class Generic";
          break;
        case HID_USAGE_SCALE_SCALE_ATTRIBUTE_REPORT:
          *UsageText = "Scale Attribute Report";
          break;
        case HID_USAGE_SCALE_SCALE_CONTROL_REPORT:
          *UsageText = "Scale Control Report";
          break;
        case HID_USAGE_SCALE_SCALE_DATA_REPORT:
          *UsageText = "Scale Data Report";
          break;
        case HID_USAGE_SCALE_SCALE_STATUS_REPORT:
          *UsageText = "Scale Status Report";
          break;
        case HID_USAGE_SCALE_SCALE_WEIGHT_LIMIT_REPORT:
          *UsageText = "Scale Weight Limit Report";
          break;
        case HID_USAGE_SCALE_SCALE_STATISTICS_REPORT:
          *UsageText = "Scale Statistics Report";
          break;
        case HID_USAGE_SCALE_DATA_WEIGHT:
          *UsageText = "Data Weight";
          break;
        case HID_USAGE_SCALE_DATA_SCALING:
          *UsageText = "Data Scaling";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_CLASS:
          *UsageText = "Weight Unit Class";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_MILLIGRAM:
          *UsageText = "Weight Unit Milligram";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_GRAM:
          *UsageText = "Weight Unit Gram";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_KILOGRAM:
          *UsageText = "Weight Unit Kilogram";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_CARATS:
          *UsageText = "Weight Unit Carats";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_TAELS:
          *UsageText = "Weight Unit Taels";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_GRAINS:
          *UsageText = "Weight Unit Grains";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_PENNYWEIGHTS:
          *UsageText = "Weight Unit Pennyweights";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_METRIC_TON:
          *UsageText = "Weight Unit Metric Ton";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_AVOIR_TON:
          *UsageText = "Weight Unit Avoir Ton";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_TROY_OUNCE:
          *UsageText = "Weight Unit Troy Ounce";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_OUNCE:
          *UsageText = "Weight Unit Ounce";
          break;
        case HID_USAGE_SCALE_WEIGHT_UNIT_POUND:
          *UsageText = "Weight Unit Pound";
          break;
        case HID_USAGE_SCALE_CALIBRATION_COUNT:
          *UsageText = "Calibration Count";
          break;
        case HID_USAGE_SCALE_RE_ZERO_COUNT:
          *UsageText = "Re-Zero Count";
          break;
        case HID_USAGE_SCALE_SCALE_STATUS_CLASS:
          *UsageText = "Scale Status Class";
          break;
        case HID_USAGE_SCALE_SCS_FAULT:
          *UsageText = "Scale Status Fault";
          break;
        case HID_USAGE_SCALE_SCS_STABLE_AT_CENTER_OF_ZERO:
          *UsageText = "Scale Status Stable at Center of Zero";
          break;
        case HID_USAGE_SCALE_SCS_IN_MOTION:
          *UsageText = "Scale Status In Motion";
          break;
        case HID_USAGE_SCALE_SCS_WEIGHT_STABLE:
          *UsageText = "Scale Status Weight Stable";
          break;
        case HID_USAGE_SCALE_SCS_UNDER_ZERO:
          *UsageText = "Scale Status Under Zero";
          break;
        case HID_USAGE_SCALE_SCS_OVER_WEIGHT_LIMIT:
          *UsageText = "Scale Status Over Weight Limit";
          break;
        case HID_USAGE_SCALE_SCS_REQUIRES_CALIBRATION:
          *UsageText = "Scale Status Requires Calibration";
          break;
        case HID_USAGE_SCALE_SCS_REQUIRES_REZEROING:
          *UsageText = "Scale Status Requires Rezeroing";
          break;
        case HID_USAGE_SCALE_ZERO_SCALE:
          *UsageText = "Scale Status Zero Scale";
          break;
        case HID_USAGE_SCALE_ENFORCED_ZERO_RETURN:
          *UsageText = "Scale Status Enforced Zero Return";
          break;
      }
      break;
    case HID_USAGE_PAGE_MAGNETIC_STRIPE_READER:
      *UsagePageText = "Magnetic Stripe Reader";
      switch(Usage)
      {
        case HID_USAGE_MSR_UNDEFINED:
          *UsageText = "Undefined";
          break;
        case HID_USAGE_MSR_MSR_DEVICE_READ_ONLY:
          *UsageText = "MSR Device Read Only";
          break;
        case HID_USAGE_MSR_TRACK_1_LENGTH:
          *UsageText = "Track 1 Length";
          break;
        case HID_USAGE_MSR_TRACK_2_LENGTH:
          *UsageText = "Track 2 Length";
          break;
        case HID_USAGE_MSR_TRACK_3_LENGTH:
          *UsageText = "Track 3 Length";
          break;
        case HID_USAGE_MSR_TRACK_JIS_LENGTH:
          *UsageText = "Track JIS Length";
          break;
        case HID_USAGE_MSR_TRACK_DATA:
          *UsageText = "Track Data";
          break;
        case HID_USAGE_MSR_TRACK_1_DATA:
          *UsageText = "Track 1 Data";
          break;
        case HID_USAGE_MSR_TRACK_2_DATA:
          *UsageText = "Track 2 Data";
          break;
        case HID_USAGE_MSR_TRACK_3_DATA:
          *UsageText = "Track 3 Data";
          break;
        case HID_USAGE_MSR_TRACK_JIS_DATA:
          *UsageText = "Track JIS Data";
          break;
      }
      break;
  }

  if(*UsagePageText == NULL)
    UsagePageText->sprintf("%x", UsagePage);
  if(*UsageText == "")
    UsageText->sprintf("%x", Usage);
}
