


# Metaprogramming with Python

<a href="https://www.packtpub.com/product/metaprogramming-with-python/9781838554651?utm_source=github&utm_medium=repository&utm_campaign=9781838554651"><img src="https://static.packt-cdn.com/products/9781838554651/cover/smaller" alt="Metaprogramming with Python" height="256px" align="right"></a>

This is the code repository for [Metaprogramming with Python](https://www.packtpub.com/product/metaprogramming-with-python/9781838554651?utm_source=github&utm_medium=repository&utm_campaign=9781838554651), published by Packt.

**A programmer's guide to writing reusable code to build smarter applications**

## What is this book about?
Effective and reusable code makes your application development process seamless and easily maintainable. With Python, you will have access to advanced metaprogramming features that you can use to build high-performing applications. 

This book covers the following exciting features:
* Understand the programming paradigm of metaprogramming and its need
* Revisit the fundamentals of object-oriented programming
* Define decorators and work with metaclasses
* Employ introspection and reflection on your code
* Apply generics, typing, and templates to enhance your code
* Get to grips with the structure of your code through abstract syntax trees and the behavior through method resolution order
* Create dynamic objects and generate dynamic code
* Understand various design patterns and best practices

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1838554653) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
actualclass = compile(class_tree, 'vegctr_tree', 'exec')
actualclass
```

**Following is what you need for this book:**
If you are an intermediate-level Python programmer looking to enhance your coding skills by developing reusable and advanced frameworks, then this book is for you. Basic knowledge of Python programming will help you get the most out of this learning journey.

With the following software and hardware list you can run all code files present in the book (Chapter 1-16).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-16 | Python 3 | Windows, Mac OS X, and Linux (Any) |
| 1-16 | Anaconda | Windows, Mac OS X, and Linux (Any) |
| 1-16 | Jupyter Notebook | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://packt.link/LTQbb).

### Related products
* Learn Python Programming [[Packt]](https://www.packt.com/product/programming/b17579-learn-python-programming/?utm_source=github&utm_medium=repository&utm_campaign=9781801073240) [[Amazon]](https://www.amazon.com/dp/1801815097)

* Mastering Python [[Packt]](https://www.packt.com/product/programming/b15882-mastering-python/?utm_source=github&utm_medium=repository&utm_campaign=9781800568754) [[Amazon]](https://www.amazon.com/dp/1800207727)

## Get to Know the Author
**Sulekha AloorRavi**
 is an engineer and a data scientist with a wide technical breadth and deep understanding of many technologies and systems. Her background has led her to advanced Python based application development in the field of artificial intelligence. She enjoys solving real-world business problems with technology and working with data science and business intelligence teams to deliver real value.
She has 15+ years of experience in Software Engineering and worked with major IT solution providers and International Banks. She graduated with an engineering degree in Information Technology and later completed a post-graduation program in Big Data and Machine Learning. She also enjoys teaching Artificial Intelligence and Machine Learning.
### Download a free PDF

 <i>If you have already purchased a print or Kindle version of this book, you can get a DRM-free PDF version at no cost.<br>Simply click on the link to claim your free PDF.</i>
<p align="center"> <a href="https://packt.link/free-ebook/9781838554651">https://packt.link/free-ebook/9781838554651 </a> </p>